% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{method_mvnorm}
\alias{method_mvnorm}
\title{Bivariate parametric normal HDR estimator}
\usage{
method_mvnorm()
}
\description{
Function used to specify bivariate normal density estimator
for \code{get_hdr()} and layer functions (e.g. \code{geom_hdr()}).
}
\details{
For more details on the use and implementation of the \verb{method_*()} functions,
see \code{vignette("method", "ggdensity")}.
}
\examples{
# Normal estimator is useful when an assumption of normality is appropriate
set.seed(1)
df <- data.frame(x = rnorm(1e3), y = rnorm(1e3))

ggplot(df, aes(x, y)) +
  geom_hdr(method = method_mvnorm(), xlim = c(-4, 4), ylim = c(-4, 4)) +
  geom_point(size = 1)

# Can also be used with `get_hdr()` for numerical summary of HDRs
res <- get_hdr(df, method = method_mvnorm())
str(res)

}
