% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gggap.R
\name{gggap}
\alias{gggap}
\title{Define Segments in y-Axis for 'ggplot2'}
\usage{
gggap(plot, ylim, segments, tick_width, rel_heights, vjust = 0,
  margin = c(top = 1, right = 2, bottom = 1, left = 1), ...)
}
\arguments{
\item{plot}{A 'ggplot2' plot.}

\item{ylim}{The y-axis limits.}

\item{segments}{The interval of a segment. If more than one intervals are given, please use list() to concatenate them.}

\item{tick_width}{One or more numbers for each segmented y-axis.}

\item{rel_heights}{Numerical vector of relative segmented y-axis and segments heights, default is 1 and 0.}

\item{vjust}{Vertical justification. Default = 0 (baseline at y).}

\item{margin}{Margins around the text.}

\item{...}{Arguments will be handed to plot_grid() in 'cowplot'.}
}
\value{
A segmented picture.
}
\description{
Easy-to-define segments in y-axis for 'ggplot2'.
}
\examples{
data(mtcars)
library(ggplot2)
p <- ggplot(data = mtcars, aes(x = gear, fill = gear)) +
  geom_bar() +
  ggtitle("Number of Cars by Gears") +
  xlab("Gears")

# single segments and missing tick_width
gggap(
  plot = p,
  segments = c(5, 10),
  ylim = c(0, 50)
)

# tick_width can be one or more numbers
gggap(
  plot = p,
  segments = c(5, 10),
  tick_width = c(1, 10),
  ylim = c(0, 50)
)

# segments list cantains more than one number vectors
gggap(
  plot = p,
  segments = list(c(2.5, 4), c(5, 10)),
  tick_width = c(1, 0.5, 10),
  ylim = c(0, 50)
)

# rel_heights can set the relative height for segments and segmented y-axis
gggap(
  plot = p,
  segments = list(c(2.5, 4), c(5, 10)),
  tick_width = c(1, 0.5, 10),
  rel_heights = c(0.2, 0, 0.2, 0, 1),
  ylim = c(0, 50)
)

# reversed y-axis
p <- ggplot(
  data = mtcars,
  aes(x = gear, fill = gear)) +
  geom_bar() +
  ggtitle("Number of Cars by Gears") +
  xlab("Gears")+
  scale_y_continuous(trans = 'reverse')

#single segments and missing tick_width
gggap(
  plot = p,
  segments = c(10, 5),
  ylim = c(15, 0))
}
