% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_moon.R
\name{geom_moon}
\alias{geom_moon}
\title{Moon charts}
\usage{
geom_moon(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
The moon geom is used to create moon charts, which are like pie charts except
that the proportions are shown as crescent or gibbous portions of a circle,
like the lit and unlit portions of the moon. As such, they work best with
only one or two groups.
}
\details{
\code{geom_moon} acts like \code{geom_point} in that multiple moons can be
plotted on the same panel with \code{x} and \code{y} in the plot's coordinate
system, but size determined independently of the coordinate system. This
behavior also means that the moons will always be circular even if the
coordinate system is not square.

In order to get a full circle with two complementary sections (a crescent and
a gibbous moon), you need to plot two shapes: one with \code{right = TRUE}
and one with \code{right = FALSE}, with \code{ratio} on the second one equal
to \code{1 - ratio} on the first.
}
\section{Aesthetics}{

\code{x} and \code{y} are required aesthetics.
\code{size}, \code{fill},
\code{colo(u)r}, \code{alpha}, \code{stroke}, and \code{group} aesthetics
are understood as in other \code{geom}s.
Two new aesthetics are also introduced: \code{ratio} and \code{right}.
\code{ratio} controls the proportion of the moon to be plotted, from 0 to 1.
\code{right} takes a boolean value to indicate whether the moon should be
filled from the right or the left.
}

\examples{
ggplot(
  data.frame(x = 1:5, y = 1, size = 1:5, ratio = 1:5 * 0.2),
  aes(x = x, y = y, size = size, ratio = ratio)
) +
  geom_moon()

# To make full moon charts, you need two calls to geom_moon(), one with
# right = TRUE and one with right = FALSE and ratio equal to 1 - ratio
# from the first one 
ggplot(dmeladh) +
  geom_moon(
    x = 0.5, y = 0.5, fill = "forestgreen", color = "forestgreen",
    aes(ratio = AdhF / 100)
  ) +
  geom_moon(
    x = 0.5, y = 0.5, fill = "gold", color = "gold",
    aes(ratio = AdhS / 100), right = FALSE
  ) +
  facet_wrap(~Locality, ncol = 7)

# The same thing can be accomplished with a single call to geom_moon()
# using a "long" data frame with both frequencies if you set a grouping
# variable and set the `right` variable to a boolean column
dmeladh_long <- reshape(
  dmeladh,
  varying = c("AdhF", "AdhS"),
  v.names = "freq",
  timevar = "allele",
  times = c("AdhF", "AdhS"),
  idvar = c("Locality", "Latitude", "Longitude", "N"),
  direction = "long"
)
dmeladh_long$right <- rep(c(TRUE, FALSE), each = nrow(dmeladh))
ggplot(dmeladh_long) +
  geom_moon(
    x = 0.5, y = 0.5, key_glyph = draw_key_rect,
    aes(ratio = freq / 100, fill = allele, color = allele, right = right),
  ) +
  facet_wrap(~Locality, ncol = 7)

# Moon charts (and pie charts) are sometimes useful on maps when x and y
# cannot be used as aesthetic dimensions because they are already spatial
# dimensions. Overplotting needs to be considered carefully, however.   
ggplot(
  subset(dmeladh, N > 200),
  aes(Longitude, Latitude)
) +
  geom_moon(aes(ratio = AdhF / 100), fill = "black") +
  geom_moon(aes(ratio = AdhS / 100), right = FALSE) +
  coord_fixed()
}
