% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conveniences.R
\name{center_limits}
\alias{center_limits}
\title{Center limits}
\usage{
center_limits(around = 0)
}
\arguments{
\item{around}{A \code{numeric} of length 1 indicating around which value to
center the limits.}
}
\value{
A \code{function} that takes limits and returns expanded limits
centered at the \code{around} argument.
}
\description{
This a function factory that allows the centering of scales around a certain
value while still including all values. Convenient for centering log2 fold
change limits around zero.
}
\examples{
center_limits(5)(c(3,8))

g <- ggplot(iris,
            aes(Sepal.Width, Sepal.Length,
                colour = log2(Petal.Width / Petal.Length))) +
  geom_point() +
  scale_colour_gradient2(limits = center_limits())
}
