% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcp_scale.r
\name{pcp_scale}
\alias{pcp_scale}
\title{Data wrangling for GPCPs: Step 2 scale values}
\usage{
pcp_scale(data, method = "uniminmax", .by_group = TRUE)
}
\arguments{
\item{data}{data frame as returned by \code{select_pcp}}

\item{method}{string specifying the method that should be used for scaling the values
in a parallel coordinate plot (see Details).}

\item{.by_group}{logical value. If TRUE, scaling will respect any previous grouping variables. Applies to grouped data frames only.}
}
\value{
data frame of the same size as the input data; values of \code{pcp_y} and
\code{pcp_yend} are scaled according to the specified method.
}
\description{
The function \code{pcp_scale} provides access to a set of transformations to use
in parallel coordinate plots. All transformations other than \code{raw} tend to
produce y values in the interval from 0 and 1.
}
\details{
The data pipeline feeding any of the geom layers in the \code{ggpcp} package is
implemented in a three-step modularized form rather than as the stat
functions more typical for \code{ggplot2} extensions.
The three steps of data pre-processing are:\tabular{ll}{
   \strong{command} \tab \strong{data processing step} \cr
   \code{pcp_select} \tab variable selection (and horizontal ordering) \cr
   \code{pcp_scale} \tab (vertical) scaling of values \cr
   \code{pcp_arrange} \tab dealing with tie-breaks on categorical axes \cr
}


Note that these data processing steps are executed before the call to \code{ggplot2}
and the identity function is used by default in all of the \code{ggpcp} specific layers.
Besides the speed-up by only executing the processing steps once for all layers,
the separation has the additional benefit, that it provides the users with the
possibility to make specific choices at each step in the process. Additionally,
separation allows for a cleaner user interface: parameters affecting the data
preparation process can be moved to the relevant (set of) function(s) only, thereby
reducing the  number of arguments without any loss of functionality.

\code{method} is a character string that denotes how to scale the variables
in the parallel coordinate plot. Options are named in the same way as the options in \code{\link[GGally:ggparcoord]{GGally::ggparcoord()}}:
\itemize{
\item{\code{raw}}{: raw data used, no scaling will be done.}
\item{\code{std}}{: univariately, subtract mean and divide by standard deviation. To get values into a unit interval we use a linear transformation of f(y) = y/4+0.5. }
\item{\code{robust}}{: univariately, subtract median and divide by median absolute deviation. To get values into an expected interval of unit interval we use a linear transformation of f(y) = y/4+0.5. }
\item{\code{uniminmax}}{: univariately, scale so the minimum of the variable is zero, and the maximum is one.}
\item{\code{globalminmax}}{: global scaling; the global maximum is mapped to 1,
global minimum across the variables is mapped to 0. }
}
}
\examples{
data(Carcinoma)
dim(Carcinoma)
# select all variables
pcp_data <- Carcinoma |> pcp_select(1:9)
summary(pcp_data)
pcp_data |> pcp_scale() |> summary()
# scaling gets values of pcp_y and pcp_yend between 0 and 1
}
\seealso{
\code{\link[=pcp_select]{pcp_select()}}, \code{\link[=pcp_arrange]{pcp_arrange()}}
}
