% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{labs}
\alias{labs}
\alias{xlab}
\alias{ylab}
\alias{ggtitle}
\alias{get_labs}
\title{Modify axis, legend, and plot labels}
\usage{
labs(
  ...,
  title = waiver(),
  subtitle = waiver(),
  caption = waiver(),
  tag = waiver(),
  dictionary = waiver(),
  alt = waiver(),
  alt_insight = waiver()
)

xlab(label)

ylab(label)

ggtitle(label, subtitle = waiver())

get_labs(plot = get_last_plot())
}
\arguments{
\item{...}{New name-value pairs. The name should be an aesthetic. The values can be
one of the following:
\itemize{
\item A string or expression to set a label verbatim.
\item A function to use as formatter for the default label.
\item \code{NULL} to remove a label.
\item A \code{\link[=waiver]{waiver()}} to use the default label.
}}

\item{title}{The text for the title.}

\item{subtitle}{The text for the subtitle for the plot which will be
displayed below the title.}

\item{caption}{The text for the caption which will be displayed in the
bottom-right of the plot by default.}

\item{tag}{The text for the tag label which will be displayed at the
top-left of the plot by default.}

\item{dictionary}{A named character vector to serve as dictionary.
Automatically derived labels, such as those based on variables will
be matched with \code{names(dictionary)} and replaced by the matching
entry in \code{dictionary}.}

\item{alt, alt_insight}{Text used for the generation of alt-text for the plot.
See \link{get_alt_text} for examples. \code{alt} can also be a function that
takes the plot as input and returns text as output. \code{alt} also accepts
rlang \link[rlang:as_function]{lambda} function notation.}

\item{label}{The title of the respective axis (for \code{xlab()} or \code{ylab()}) or
of the plot (for \code{ggtitle()}).}

\item{plot}{A ggplot object}
}
\description{
Good labels are critical for making your plots accessible to a wider
audience. Always ensure the axis and legend labels display the full
variable name. Use the plot \code{title} and \code{subtitle} to explain the
main findings. It's common to use the \code{caption} to provide information
about the data source. \code{tag} can be used for adding identification tags
to differentiate between multiple plots.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}: \code{xlab()}, \code{ylab()} and \code{ggtitle()} are
superseded. It is recommended to use the \code{labs(x, y, title, subtitle)}
arguments instead.

\code{get_labs()} retrieves completed labels from a plot.
}
\details{
You can also set axis and legend labels in the individual scales (using
the first argument, the \code{name}). If you're changing other scale options, this
is recommended.

If a plot already has a title, subtitle, caption, etc., and you want to
remove it, you can do so by setting the respective argument to \code{NULL}. For
example, if plot \code{p} has a subtitle, then \code{p + labs(subtitle = NULL)} will
remove the subtitle from the plot.
}
\examples{
p <- ggplot(mtcars, aes(mpg, wt, colour = cyl)) + geom_point()
p + labs(colour = "Cylinders")
p + labs(x = "New x label")

# Set labels by variable name instead of aesthetic
p + labs(dictionary = c(
  disp = "Displacment", # Not in use
  cyl  = "Number of cylinders",
  mpg  = "Miles per gallon",
  wt   = "Weight (1000 lbs)"
))

# The plot title appears at the top-left, with the subtitle
# display in smaller text underneath it
p + labs(title = "New plot title")
p + labs(title = "New plot title", subtitle = "A subtitle")

# The caption appears in the bottom-right, and is often used for
# sources, notes or copyright
p + labs(caption = "(based on data from ...)")

# The plot tag appears at the top-left, and is typically used
# for labelling a subplot with a letter.
p + labs(title = "title", tag = "A")

# If you want to remove a label, set it to NULL.
p +
 labs(title = "title") +
 labs(title = NULL)
}
\seealso{
The \href{https://ggplot2-book.org/annotations#sec-titles}{plot and axis titles section} of the online ggplot2 book.
}
