% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_fill_ul.R
\name{scale_fill_ul}
\alias{scale_fill_ul}
\title{University of Ljubljana theme (fill) scale}
\usage{
scale_fill_ul(
  palette = "primary",
  discrete = TRUE,
  reverse = FALSE,
  midpoint = NA,
  neutralColor = "white",
  guide = guide_colourbar(frame.colour = "#58595b", title.vjust = 0.8),
  ...
)
}
\arguments{
\item{palette}{A character string indicating the color palette to use. Default is \code{"primary"}. See \code{?ul_pal} for other options.}

\item{discrete}{A logical indicating whether the scale is discrete. Default is \code{TRUE}.}

\item{reverse}{A logical indicating whether to reverse the order of colors in the palette. Default is \code{FALSE}.}

\item{midpoint}{A numeric value indicating the midpoint for the color scale in case of a divergent color scale (default is \code{NA}).}

\item{neutralColor}{A character string specifying the color to use for neutral values (default is \code{"white"}).}

\item{guide}{A guide function specification, such as \code{guide_colorbar()} or \code{guide_legend()}, used to modify specific guide properties (default is \code{guide_colourbar(frame.colour = "#58595b", title.vjust = 0.8)}).}

\item{...}{Other arguments passed on to the scale functions (\code{discrete_scale}, \code{scale_fill_gradientn} or \code{scale_fill_gradient2}).}
}
\value{
A discrete or gradient fill scale.
}
\description{
Applies color fill to the given data based on the University of Ljubljana's visual identity guidelines.
}
\details{
This function returns a color fill scale to be used with ggplot2. It uses color palettes defined according to the visual identity of the University of Ljubljana.
}
\examples{
ggplot(mtcars, aes(x = mpg, fill = factor(cyl))) +
geom_density(alpha = 0.7) +
scale_fill_ul(discrete = TRUE)
}
\seealso{
\code{\link[ggplot2]{scale_fill_gradientn}}, \code{\link[ggplot2]{scale_fill_gradient2}}, \code{\link[ggplot2]{discrete_scale}}
}
