% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-path-trace.R
\name{geom_path_trace}
\alias{geom_path_trace}
\alias{geom_line_trace}
\alias{geom_step_trace}
\title{Trace lines}
\usage{
geom_path_trace(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  trace_position = "all",
  background_params = list(color = NA),
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  arrow = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_line_trace(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE,
  trace_position = "all",
  background_params = list(color = NA),
  ...
)

geom_step_trace(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  direction = "hv",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  trace_position = "all",
  background_params = list(color = NA),
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{trace_position}{Specifies which data points to outline, can be one of:

\itemize{
  \item "all" to outline every group plotted
  \item A predicate specifying which data points to outline. This must
        evaluate to \code{TRUE} or \code{FALSE} within the context of the
        input data. e.g. \code{value > 100}
}}

\item{background_params}{Named list specifying aesthetic parameters to use
for background data points when a predicate is passed to
\code{trace_position}, e.g. \code{list(color = "red")}}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{linemitre}{Line mitre limit (number greater than 1).}

\item{arrow}{Arrow specification, as created by \code{\link[grid:arrow]{grid::arrow()}}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{orientation}{The orientation of the layer. The default (\code{NA})
automatically determines the orientation from the aesthetic mapping. In the
rare event that this fails it can be given explicitly by setting \code{orientation}
to either \code{"x"} or \code{"y"}. See the \emph{Orientation} section for more detail.}

\item{direction}{direction of stairs: 'vh' for vertical then horizontal,
'hv' for horizontal then vertical, or 'mid' for step half-way between
adjacent x-values.}
}
\value{
ggplot object
}
\description{
These geoms are similar to \code{ggplot2::geom_path()},
\code{ggplot2::geom_line()}, and \code{ggplot2::geom_step()}, but also
include the ability to highlight line segments of interest.
These geoms accept normal ggplot2 graphical parameters with
some modifications. \code{fill} controls the color of the center line,
\code{color} controls the outline color, and \code{stroke} controls
outline width, similar to how filled shapes are modified for other ggplot2
geoms. Additional parameters including \code{size}, \code{alpha},
\code{linetype}, \code{linejoin}, \code{lineend},  and \code{linemitre} are
also accepted.
}
\section{Aesthetics}{

\code{geom_path_trace()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
  \item \strong{\code{x}}
  \item \strong{\code{y}}
  \item \code{alpha}
  \item \code{colour}
  \item \code{fill}
  \item \code{group}
  \item \code{linetype}
  \item \code{size}
  \item \code{stroke}
}
Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.
}

\examples{
# Modify line color for each group
ggplot2::ggplot(
  stocks,
  ggplot2::aes(day, value, fill = name)
) +
  geom_line_trace() +
  ggplot2::theme_minimal()

# Modify outline color for each group
ggplot2::ggplot(
  stocks,
  ggplot2::aes(day, value, color = name)
) +
  geom_line_trace() +
  ggplot2::theme_minimal()

# Specify outline color for each group
clrs <- c(
  CAC  = "#E69F00",
  DAX  = "#0072B2",
  FTSE = "#009E73",
  SMI  = "#56B4E9"
)

ggplot2::ggplot(
  stocks,
  ggplot2::aes(day, value, color = name)
) +
  geom_line_trace(stroke = 1) +
  ggplot2::scale_color_manual(values = clrs) +
  ggplot2::theme_minimal()

# Outline a subset of data points
ggplot2::ggplot(
  stocks,
  ggplot2::aes(day, value, color = name)
) +
  geom_line_trace(trace_position = day > 1500, stroke = 1) +
  ggplot2::theme_minimal()

# Modify appearance of background data points
ggplot2::ggplot(
  stocks,
  ggplot2::aes(day, value, color = name)
) +
  geom_line_trace(
    trace_position    = day > 1500,
    background_params = list(color = NA, fill = "grey75"),
    stroke            = 1
  ) +
  ggplot2::theme_minimal()

# Remove outline
ggplot2::ggplot(
  stocks,
  ggplot2::aes(day, value, fill = name)
) +
  geom_line_trace(
    trace_position    = day > 1500,
    background_params = list(fill = "grey75"),
    color             = NA
  ) +
  ggplot2::theme_minimal()

}
\seealso{
\link[ggplot2]{geom_path}; \link[ggplot2]{geom_line}; \link[ggplot2]{geom_step}
}
