% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gigg_fixed_gibbs_sampler}
\alias{gigg_fixed_gibbs_sampler}
\title{Gibbs sampler for GIGG regression with fixed hyperparameters.}
\usage{
gigg_fixed_gibbs_sampler(
  X,
  C,
  Y,
  grp_idx,
  grp_size,
  grp_size_cs,
  alpha_inits,
  beta_inits,
  lambda_sq_inits,
  gamma_sq_inits,
  eta_inits,
  p,
  q,
  tau_sq_init = 1,
  sigma_sq_init = 1,
  nu_init = 1,
  n_burn_in = 500L,
  n_samples = 1000L,
  n_thin = 1L,
  stable_const = 1e-07,
  verbose = TRUE,
  btrick = FALSE,
  stable_solve = FALSE
)
}
\arguments{
\item{X}{A (n x M) matrix of covariates that we want to apply GIGG shrinkage on.}

\item{C}{A (n x K) matrix of covariates that we want to apply no shrinkage on (typically intercept + adjustment covariates).}

\item{Y}{A (n x 1) column vector of responses.}

\item{grp_idx}{A (1 x M) row vector indicating which group of the J groups the M covariates in X belong to.}

\item{grp_size}{A (1 x J) row vector indicating the number of covariates in each group.}

\item{grp_size_cs}{A (1 x J) row vector that is the cumulative sum of grp_size (indicating the indicies where each group ends).}

\item{alpha_inits}{A (K x 1) column vector containing initial values for the regression coefficients corresponding to C.}

\item{beta_inits}{A (M x 1) column vector containing initial values for the regression coefficients corresponding to X.}

\item{lambda_sq_inits}{A (M x 1) column vector containing initial values for the local shrinkage parameters.}

\item{gamma_sq_inits}{A (J x 1) column vector containing initial values for the group shrinkage parameters.}

\item{eta_inits}{A (J x 1) column vector containing initial values for the mixing parameters.}

\item{p}{A (J x 1) column vector of shape parameter for the prior on the group shrinkage parameters.}

\item{q}{A (J x 1) column vector of shape parameter for the prior on the individual shrinkage parameters.}

\item{tau_sq_init}{Initial value for the global shrinkage parameter (double).}

\item{sigma_sq_init}{Initial value for the residual variance (double).}

\item{nu_init}{Initial value for the augmentation variable (double).}

\item{n_burn_in}{The number of burn-in samples (integer).}

\item{n_samples}{The number of posterior draws (integer).}

\item{n_thin}{The thinning interval (integer).}

\item{stable_const}{Parameter that controls numerical stability of the algorithm (double).}

\item{verbose}{Boolean value which indicates whether or not to print the progress of the Gibbs sampler.}

\item{btrick}{Boolean value which indicates whether or not to use the computational trick in Bhattacharya et al. (2016). Only recommended if number of covariates is much larger than the number of observations.}

\item{stable_solve}{default to FALSE}
}
\value{
A list containing the posterior draws of (1) the regression coefficients (alphas and betas) (2) the individual shrinkage parameters (lambda_sqs) (3) the group shrinkage parameters (gamma_sqs) (4) the global shrinkage parameter (tau_sqs) and (5) the residual error variance (sigma_sqs). The list also contains details regarding the dataset (X, C, Y, grp_idx) and Gibbs sampler details (n_burn_in, n_samples, and n_thin).
}
\description{
An Rcpp function that implements a Gibbs sampler for GIGG regression with fixed hyperparameters.
}
