% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnssts.R
\name{create.gnssts}
\alias{create.gnssts}
\title{Create a gnssts object}
\usage{
create.gnssts(t, y, jumps = NULL, sampling_period = 1)
}
\arguments{
\item{t}{A \code{vector} specifying the time of each observation of the time series.}

\item{y}{A \code{vector} specifying the values of each observation of the time series.}

\item{jumps}{A \code{vector} specifying the time values for which there is a jump.}

\item{sampling_period}{An \code{integer} specifying the sampling period.}
}
\value{
A \code{gnssts} object.
}
\description{
Create a gnssts object
}
\examples{
phase <- 0.45
amplitude <- 2.5
sigma2_wn <- 15
bias <- 0
trend <- 5 / 365.25
cosU <- amplitude * cos(phase)
sinU <- amplitude * sin(phase)
year <- 5
n <- year * 365
jump_vec <- c(200, 300, 500)
jump_height <- c(10, 15, 20)
nbr_sin <- 1 
A <- create_A_matrix(1:n, jump_vec, n_seasonal = nbr_sin)
x_0 <- c(bias, trend, cosU, sinU, jump_height)
eps <- rnorm(n = n, sd = sqrt(sigma2_wn))
yy <- A \%*\% x_0 + eps
gnssts_obj <- create.gnssts(t = 1:length(yy), y = yy, jumps = jump_vec)
str(gnssts_obj)

}
