% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{metagraph}
\alias{metagraph}
\title{Plot the metagraph of the parameter of the stochastic block model associated
with one of the estimated graph clusters}
\usage{
metagraph(nb, res, title = NULL, edge.width.cst = 10)
}
\arguments{
\item{nb}{number of the cluster we are interested in}

\item{res}{output of graphClustering()}

\item{title}{title of the figure}

\item{edge.width.cst}{width of edges in the metagraph}
}
\value{
none
}
\description{
Plot the metagraph of the parameter of the stochastic block model associated
with one of the estimated graph clusters
}
\examples{
theta <- list(pi=c(.5,.5), gamma=matrix((1:4)/8,2,2))
obs <- rCollectSBM(rep(10,4), theta)$listGraphs
res <- graphClustering(obs, nbCores=2)
metagraph(1, res)
}
