% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_flights.R
\name{getFlightGraph}
\alias{getFlightGraph}
\title{Get flight graph}
\usage{
getFlightGraph(IATAs = NULL, years = NULL, minNFlights = 1, directed = FALSE)
}
\arguments{
\item{IATAs}{Character vector. IATA codes of airports to include}

\item{years}{Character vector. Years to include (as strings).}

\item{minNFlights}{Numerical scalar. Minimum number of flights on a connection to
be included as an edge.}

\item{directed}{Logical scalar. Whether flights A->B and B->A should be considered separately.}
}
\value{
An \code{\link[igraph:make_graph]{igraph::graph}} object containing a vertex for each airport
and an edge whenever there are at least \code{minNFlights} between two airports.
}
\description{
Convert the info from \code{flights$flightCounts} to an \code{\link[igraph:make_graph]{igraph::graph}} object.
}
\examples{
g <- getFlightGraph()

}
\seealso{
Other flight data related topics:
\code{\link{flightCountMatrixToConnectionList}()},
\code{\link{flights}},
\code{\link{getFlightDelayData}()},
\code{\link{plotFlights}()}
}
\concept{flightData}
