% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.graph_report.R
\name{print.graph_report}
\alias{print.graph_report}
\title{S3 print method for the class \code{graph_report}}
\usage{
\method{print}{graph_report}(x, ..., precision = 4, indent = 2, rows = 10)
}
\arguments{
\item{x}{An object of class \code{graph_report} to print.}

\item{...}{Other values passed on to other methods (currently unused)}

\item{precision}{An integer scalar indicating the number of decimal places
to to display.}

\item{indent}{An integer scalar indicating how many spaces to indent results.}

\item{rows}{An integer scalar indicating how many rows of detailed test
results to print.}
}
\value{
An object x of class \code{graph_report}, after printing the report of
conducting a graphical multiple comparison procedure.
}
\description{
A printed \code{graph_report} displays the initial graph, p-values and
significance levels, rejection decisions, and optional detailed test results.
}
\examples{
# A graphical multiple comparison procedure with two primary hypotheses (H1
# and H2) and two secondary hypotheses (H3 and H4)
# See Figure 1 in Bretz et al. (2011).
hypotheses <- c(0.5, 0.5, 0, 0)
transitions <- rbind(
  c(0, 0, 1, 0),
  c(0, 0, 0, 1),
  c(0, 1, 0, 0),
  c(1, 0, 0, 0)
)
g <- graph_create(hypotheses, transitions)

p <- c(0.018, 0.01, 0.105, 0.006)
alpha <- 0.025
graph_test_shortcut(g, p, alpha)
}
\references{
Bretz, F., Posch, M., Glimm, E., Klinglmueller, F., Maurer, W., and
Rohmeyer, K. (2011). Graphical approaches for multiple comparison
procedures using weighted Bonferroni, Simes, or parametric tests.
\emph{Biometrical Journal}, 53(6), 894-913.
}
