% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.initial_graph.R
\name{print.initial_graph}
\alias{print.initial_graph}
\title{S3 print method for the class \code{initial_graph}}
\usage{
\method{print}{initial_graph}(x, ..., precision = 4, indent = 0)
}
\arguments{
\item{x}{An object of class \code{initial_graph} to print.}

\item{...}{Other values passed on to other methods (currently unused).}

\item{precision}{An integer scalar indicating the number of decimal places
to to display.}

\item{indent}{An integer scalar indicating how many spaces to indent results.}
}
\value{
An object x of class \code{initial_graph}, after printing the initial
graph.
}
\description{
A printed \code{initial_graph} displays a header stating "Initial graph",
hypothesis weights, and transition weights.
}
\examples{
# A graphical multiple comparison procedure with two primary hypotheses (H1
# and H2) and two secondary hypotheses (H3 and H4)
# See Figure 1 in Bretz et al. (2011).
hypotheses <- c(0.5, 0.5, 0, 0)
transitions <- rbind(
  c(0, 0, 1, 0),
  c(0, 0, 0, 1),
  c(0, 1, 0, 0),
  c(1, 0, 0, 0)
)
hyp_names <- c("H11", "H12", "H21", "H22")
g <- graph_create(hypotheses, transitions, hyp_names)
g
}
\references{
Bretz, F., Posch, M., Glimm, E., Klinglmueller, F., Maurer, W., and
Rohmeyer, K. (2011). Graphical approaches for multiple comparison
procedures using weighted Bonferroni, Simes, or parametric tests.
\emph{Biometrical Journal}, 53(6), 894-913.
}
\seealso{
\code{\link[=print.updated_graph]{print.updated_graph()}} for the print method for the updated graph after
hypotheses being deleted from the initial graph.
}
