% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-pattern.R
\docType{data}
\name{grid.pattern}
\alias{grid.pattern}
\alias{names_pattern}
\alias{patternGrob}
\title{Create patterned grobs by pattern name}
\format{
An object of class \code{character} of length 19.
}
\usage{
grid.pattern(
  pattern = "stripe",
  x = c(0, 0, 1, 1),
  y = c(1, 0, 0, 1),
  id = 1L,
  ...,
  legend = FALSE,
  prefix = "pattern_",
  default.units = "npc",
  name = NULL,
  gp = gpar(),
  draw = TRUE,
  vp = NULL
)

names_pattern

patternGrob(
  pattern = "stripe",
  x = c(0, 0, 1, 1),
  y = c(1, 0, 0, 1),
  id = 1L,
  ...,
  legend = FALSE,
  prefix = "pattern_",
  default.units = "npc",
  name = NULL,
  gp = gpar(),
  draw = TRUE,
  vp = NULL
)
}
\arguments{
\item{pattern}{Name of pattern.  See Details section for a list of supported patterns.}

\item{x}{A numeric vector or unit object specifying x-locations of the pattern boundary.}

\item{y}{A numeric vector or unit object specifying y-locations of the pattern boundary.}

\item{id}{A numeric vector used to separate locations in x, y into multiple boundaries.
All locations within the same \code{id} belong to the same boundary.}

\item{...}{Pattern parameters.}

\item{legend}{Whether this is intended to be drawn in a legend or not.}

\item{prefix}{Prefix to prepend to the name of each of the pattern parameters in \code{...}.
For compatibility with \code{ggpattern} most underlying functions assume parameters beginning with \code{pattern_}.}

\item{default.units}{A string indicating the default units to use if \code{x} or \code{y}
are only given as numeric vectors.}

\item{name}{ A character identifier. }

\item{gp}{An object of class \code{"gpar"}, typically the output
    from a call to the function \code{\link[grid]{gpar}}.  This is basically
    a list of graphical parameter settings.}

\item{draw}{A logical value indicating whether graphics output
    should be produced.}

\item{vp}{A Grid viewport object (or NULL).}
}
\value{
A grid grob object (invisibly in the case of \code{grid.pattern()}).
If \code{draw} is \code{TRUE} then \code{grid.pattern()} also draws to the graphic device as a side effect.
}
\description{
\code{grid.pattern()} draws patterned shapes onto the graphic device.
\code{patternGrob()} returns the grid grob objects.
\code{names_pattern} is a character vector of builtin patterns.
}
\details{
Here is a list of the various patterns supported:

\describe{
\item{ambient}{Noise array patterns onto the graphic device powered by the \code{ambient} package.
See \code{\link[=grid.pattern_ambient]{grid.pattern_ambient()}} for more information.}
\item{aRtsy}{Patterns powered by the \code{aRtsy} package.
See \code{\link[=grid.pattern_aRtsy]{grid.pattern_aRtsy()}} for more information.}
\item{circle}{Circle geometry patterns.
See \code{\link[=grid.pattern_circle]{grid.pattern_circle()}} for more information.}
\item{crosshatch}{Crosshatch geometry patterns.
See \code{\link[=grid.pattern_crosshatch]{grid.pattern_crosshatch()}} for more information.}
\item{gradient}{Gradient array/geometry patterns.
See \code{\link[=grid.pattern_gradient]{grid.pattern_gradient()}} for more information.}
\item{image}{Image array patterns.
See \code{\link[=grid.pattern_image]{grid.pattern_image()}} for more information.}
\item{magick}{\code{imagemagick} array patterns.
See \code{\link[=grid.pattern_magick]{grid.pattern_magick()}} for more information.}
\item{none}{Does nothing.
See \code{\link[grid:grid.null]{grid::grid.null()}} for more information.}
\item{pch}{Plotting character geometry patterns.
See \code{\link[=grid.pattern_pch]{grid.pattern_pch()}} for more information.}
\item{placeholder}{Placeholder image array patterns.
See \code{\link[=grid.pattern_placeholder]{grid.pattern_placeholder()}} for more information.}
\item{plasma}{Plasma array patterns.
See \code{\link[=grid.pattern_plasma]{grid.pattern_plasma()}} for more information.}
\item{polygon_tiling}{Polygon tiling patterns.
See \code{\link[=grid.pattern_polygon_tiling]{grid.pattern_polygon_tiling()}} for more information.}
\item{regular_polygon}{Regular polygon patterns.
See \code{\link[=grid.pattern_regular_polygon]{grid.pattern_regular_polygon()}} for more information.}
\item{rose}{Rose array/geometry patterns.
See \code{\link[=grid.pattern_rose]{grid.pattern_rose()}} for more information.}
\item{stripe}{Stripe geometry patterns.
See \code{\link[=grid.pattern_stripe]{grid.pattern_stripe()}} for more information.}
\item{text}{Text array/geometry patterns.
See \code{\link[=grid.pattern_text]{grid.pattern_text()}} for more information.}
\item{wave}{Wave geometry patterns.
See \code{\link[=grid.pattern_wave]{grid.pattern_wave()}} for more information.}
\item{weave}{Weave geometry patterns.
See \code{\link[=grid.pattern_weave]{grid.pattern_weave()}} for more information.}
\item{Custom geometry-based patterns}{See \url{https://trevorldavis.com/R/gridpattern/dev/articles/developing-patterns.html} for more information.}
\item{Custom array-based patterns}{See \url{https://trevorldavis.com/R/gridpattern/dev/articles/developing-patterns.html} for more information.}
}
}
\examples{
 print(names_pattern)
 \donttest{# May take more than 5 seconds on CRAN servers
 x_hex <- 0.5 + 0.5 * cos(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
 y_hex <- 0.5 + 0.5 * sin(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))

 # geometry-based patterns
 # 'stripe' pattern
 grid::grid.newpage()
 grid.pattern("stripe", x_hex, y_hex,
              colour="black", fill=c("yellow", "blue"), density = 0.5)

 # Can alternatively use "gpar()" to specify colour and line attributes
 grid::grid.newpage()
 grid.pattern("stripe", x_hex, y_hex, 
              gp = grid::gpar(col="blue", fill="red", lwd=2))

 # 'weave' pattern
 grid::grid.newpage()
 grid.pattern("weave", x_hex, y_hex, type = "satin",
              colour = "black", fill = "lightblue", fill2 =  "yellow",
              density = 0.3)

 # 'regular_polygon' pattern
 grid::grid.newpage()
 grid.pattern_regular_polygon(x_hex, y_hex, colour = "black",
                              fill = c("blue", "yellow", "red"),
                              shape = c("convex4", "star8", "circle"),
                              density = c(0.45, 0.42, 0.4),
                              spacing = 0.08, angle = 0)

 # can be used to achieve a variety of 'tiling' effects
 grid::grid.newpage()
 grid.pattern_regular_polygon(x_hex, y_hex, color = "transparent",
                              fill = c("white", "grey", "black"),
                              density = 1.0, spacing = 0.1,
                              shape = "convex6", grid = "hex")
 if (suppressPackageStartupMessages(requireNamespace("magick", quietly = TRUE))) {
   # array-based patterns
   # 'image' pattern
   logo_filename <- system.file("img", "Rlogo.png" , package="png")
   grid::grid.newpage()
   grid.pattern("image", x_hex, y_hex, filename=logo_filename, type="fit")
 }
 if (suppressPackageStartupMessages(requireNamespace("magick", quietly = TRUE))) {
   # 'plasma' pattern
   grid::grid.newpage()
   grid.pattern("plasma", x_hex, y_hex, fill="green")
 }
 }
}
\seealso{
\url{https://coolbutuseless.github.io/package/ggpattern/index.html}
for more details on the \code{ggpattern} package.
}
\keyword{datasets}
