#' Consumer Price Index (CPI) in several region In Indonesia
#'
#' A dataset containing the Consumer Price Index (CPI) in several region In Indonesia i.e Semarang, Surakarta, Tegal and Purwokerto, it is time series data with monthly periodicity from Jan 2006 to Sep 2014
#' @usage data(LocationCPI)
#' @format A time series data frame with 105 rows and 5 variables:
#' \describe{
#'   \item{Date}{date of CPI, monthly}
#'   \item{Purwokerto}{The CPI of Purwokerto region}
#'   \item{Surakarta}{The CPI of Purwokerto region}
#'   \item{Semarang}{The CPI of Purwokerto region}
#'   \item{Tegal}{The CPI of Purwokerto region}
#' }
#' @source \url{https://www.bps.go.id/}
"LocationCPI"



#' Coordinate of several region In Indonesia
#'
#' A dataset containing the coordinate several region In Indonesia i.e Semarang, Surakarta, Tegal and Purwokerto.
#' @usage data(Loc)
#' @format A data frame with 4 rows and 3 variables:
#' \describe{
#'   \item{City}{Name of region/city}
#'   \item{latitude}{The latitude coordinate of each location}
#'   \item{longitude}{The longitude coordinate of each location}
#' }
"Loc"
