% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_O2sol}
\alias{gsw_O2sol}
\title{Oxygen Solubility in Seawater (GSW variables)}
\usage{
gsw_O2sol(SA, CT, p, longitude, latitude)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ].  The valid range for most `gsw`
functions is 0 to 42 g/kg.}

\item{CT}{Conservative Temperature [ degC ].}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{longitude}{longitude in decimal degrees, positive to the east of Greenwich. (This
is called \code{long} in the TEOS-10 Matlab code.)}

\item{latitude}{latitude in decimal degrees, positive to the north of the equator. (This
is called \code{lat} in the TEOS-10 Matlab code.)}
}
\value{
Oxygen solubility in micro-moles per kg.
}
\description{
Computes oxygen concentration for seawater that is equilibrium with
vapour-saturated air at standard atmospheric pressure (101.325 kPa,
i.e. for sea pressure of 0dbar).  The formula, not created by the SCOR/IAPSO
Working Group 127 nor approved by the IOC, is stated in the TEOS-10
documentation to be from Benson and Krause (1984), as fitted by
Garcia and Gordon (1992, 1993). That formulation is framed in UNESCO-era
water properties, so longitude and latitude are needed here, to convert
to these quantities from Absolute Salinity and Conservative Temperature;
see also \code{\link{gsw_O2sol_SP_pt}}, which is formulated in UNESCO
terms.
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2022-10-11 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `657216dd4f5ea079b5f0e021a4163e2d26893371`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
p <- c(      10,      50,     125,     250,     600,    1000)
latitude <- c(4,       4,       4,       4,       4,       4)
longitude <- c(188,  188,     188,     188,     188,     188)
O2sol <- gsw_O2sol(SA,CT,p,longitude,latitude)
stopifnot(all.equal(O2sol/100, c(1.949651126384804, 1.958728907684003,
            2.148922307892045, 2.738656506758550, 2.955109771828408,
            3.133584919106894)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_O2sol.html}
}
\seealso{
Other things related to oxygen: 
\code{\link{gsw_O2sol_SP_pt}()}
}
\concept{things related to oxygen}
