% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_pt_from_t_ice}
\alias{gsw_pt_from_t_ice}
\title{Potential Temperature of Ice from in-situ Temperature}
\usage{
gsw_pt_from_t_ice(t, p, p_ref = 0)
}
\arguments{
\item{t}{in-situ temperature (ITS-90) [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{p_ref}{reference pressure [ dbar ]}
}
\value{
potential temperature [ degC ]
}
\description{
Potential Temperature of Ice from in-situ Temperature
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2022-10-11 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `657216dd4f5ea079b5f0e021a4163e2d26893371`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
t <- c(-10.7856, -13.4329, -12.8103, -12.2600, -10.8863, -8.4036)
p <- c(      10,       50,      125,      250,      600,    1000)
p_ref <- 0 # not actually needed, since 0 is the default
pt <- gsw_pt_from_t_ice(t, p, p_ref)
stopifnot(all.equal(pt, c(-10.787787898205272, -13.443730926050661, -12.837427056999676,
                          -12.314321615760921, -11.017040858094234, -8.622907355083147)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_pt_from_t_ice.html}
}
