% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_plt_conf_int.R
\name{gt_plt_conf_int}
\alias{gt_plt_conf_int}
\title{Plot a confidence interval around a point}
\usage{
gt_plt_conf_int(
  gt_object,
  column,
  ci_columns,
  ci = 0.9,
  ref_line = NULL,
  palette = c("black", "grey", "white", "black"),
  width = 45,
  text_args = list(accuracy = 1),
  text_size = 1.5
)
}
\arguments{
\item{gt_object}{An existing gt table}

\item{column}{The column that contains the mean of the sample. This can either be a single number per row, if you have calculated the values ahead of time, or a list of values if you want to calculate the confidence intervals.}

\item{ci_columns}{Optional columns representing the left/right confidence intervals of your sample.}

\item{ci}{The confidence interval, representing the percentage, ie \code{0.9} which represents \code{10-90} for the two tails.}

\item{ref_line}{A number indicating where to place reference line on x-axis.}

\item{palette}{A vector of color strings of exactly length 4. The colors represent the central point, the color of the range, the color of the stroke around the central point, and the color of the text, in that specific order.}

\item{width}{A number indicating the width of the plot in \code{"mm"}, defaults to \code{45}.}

\item{text_args}{A list of named arguments. Optional text arguments passed as a list to \code{scales::label_number}.}

\item{text_size}{A number indicating the size of the text indicators in the plot. Defaults to 1.5. Can also be set to \code{0} to "remove" the text itself.}
}
\value{
a gt table
}
\description{
Plot a confidence interval around a point
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{# gtExtras can calculate basic conf int
# using confint() function

ci_table <- generate_df(
  n = 50, n_grps = 3,
  mean = c(10, 15, 20), sd = c(10, 10, 10),
  with_seed = 37
) \%>\%
  dplyr::group_by(grp) \%>\%
  dplyr::summarise(
    n = dplyr::n(),
    avg = mean(values),
    sd = sd(values),
    list_data = list(values)
  ) \%>\%
  gt::gt() \%>\%
  gt_plt_conf_int(list_data, ci = 0.9)

# You can also provide your own values
# based on your own algorithm/calculations
pre_calc_ci_tab <- dplyr::tibble(
  mean = c(12, 10), ci1 = c(8, 5), ci2 = c(16, 15),
  ci_plot = c(12, 10)
) \%>\%
  gt::gt() \%>\%
  gt_plt_conf_int(
    ci_plot, c(ci1, ci2),
    palette = c("red", "lightgrey", "black", "red")
    )
}\if{html}{\out{</div>}}
}

\section{Figures}{

\if{html}{\figure{gt_plt_ci_calc.png}{options: width=500}}
\if{html}{\figure{gt_plt_ci_vals.png}{options: width=500}}
}

\section{Function ID}{

3-10
}

\seealso{
Other Themes: 
\code{\link{gt_plt_bullet}()},
\code{\link{gt_plt_dot}()},
\code{\link{gt_theme_538}()},
\code{\link{gt_theme_dark}()},
\code{\link{gt_theme_dot_matrix}()},
\code{\link{gt_theme_espn}()},
\code{\link{gt_theme_excel}()},
\code{\link{gt_theme_guardian}()},
\code{\link{gt_theme_nytimes}()},
\code{\link{gt_theme_pff}()}
}
\concept{Themes}
