% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{adjust_luminance}
\alias{adjust_luminance}
\title{Adjust the luminance for a palette of colors}
\usage{
adjust_luminance(colors, steps)
}
\arguments{
\item{colors}{\emph{Color vector}

\verb{vector<character>} // \strong{required}

This is the vector of colors that will undergo an adjustment in luminance.
Each color value provided must either be a color name (in the set of colors
provided by \code{grDevices::colors()}) or a hexadecimal string in the form of
"#RRGGBB" or "#RRGGBBAA".}

\item{steps}{\emph{Adjustment level}

\verb{scalar<numeric|integer>(-2>=val>=2)} // \strong{required}

A positive or negative factor by which the luminance of colors in the
\code{colors} vector will be adjusted. Must be a number between \code{-2.0} and
\code{2.0}.}
}
\value{
A vector of color values.
}
\description{
The \code{adjust_luminance()} function can brighten or darken a palette of colors
by an arbitrary number of steps, which is defined by a real number between
-2.0 and 2.0. The transformation of a palette by a fixed step in this
function will tend to apply greater darkening or lightening for those colors
in the midrange compared to any very dark or very light colors in the input
palette.
}
\details{
This function can be useful when combined with the \code{\link[=data_color]{data_color()}} function's
\code{palette} argument, which can use a vector of colors or any of the \verb{col_*}
functions from the \strong{scales} package (all of which have a \code{palette}
argument).
}
\section{Examples}{


Get a palette of 8 pastel colors from the \strong{RColorBrewer} package.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pal <- RColorBrewer::brewer.pal(8, "Pastel2")
}\if{html}{\out{</div>}}

Create lighter and darker variants of the base palette (one step lower, one
step higher).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pal_darker  <- pal |> adjust_luminance(-1.0)
pal_lighter <- pal |> adjust_luminance(+1.0)
}\if{html}{\out{</div>}}

Create a tibble and make a \strong{gt} table from it. Color each column in order
of increasingly darker palettes (with \code{\link[=data_color]{data_color()}}).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dplyr::tibble(a = 1:8, b = 1:8, c = 1:8) |>
  gt() |>
  data_color(
    columns = a,
    colors = scales::col_numeric(
      palette = pal_lighter,
      domain = c(1, 8)
    )
  ) |>
  data_color(
    columns = b,
    colors = scales::col_numeric(
      palette = pal,
      domain = c(1, 8)
    )
  ) |>
  data_color(
    columns = c,
    colors = scales::col_numeric(
      palette = pal_darker,
      domain = c(1, 8)
    )
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_adjust_luminance_1.png" alt="This image of a table was generated from the first code example in the `adjust_luminance()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

8-9
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other helper functions: 
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{escape_latex}()},
\code{\link{from_column}()},
\code{\link{google_font}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{latex}()},
\code{\link{md}()},
\code{\link{nanoplot_options}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()},
\code{\link{row_group}()},
\code{\link{stub}()},
\code{\link{system_fonts}()},
\code{\link{unit_conversion}()}
}
\concept{helper functions}
