% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-generics.R
\name{homogeneity}
\alias{homogeneity}
\alias{homogeneity.default}
\alias{homogeneity.matrix}
\alias{homogeneity.FitLandDF}
\title{Homogeneity Metric for a GLCM}
\usage{
homogeneity(x, ...)

\method{homogeneity}{default}(x, ...)

\method{homogeneity}{matrix}(x, ...)

\method{homogeneity}{FitLandDF}(x, nlevels, ...)
}
\arguments{
\item{x}{gray-level co-occurrence matrix}

\item{...}{additional parameters}

\item{nlevels}{desired number of discrete gray levels}
}
\value{
double
}
\description{
Calculate the homogeneity feature or metric for a gray-level co-occurrence
matrix. For definition and application, see Lofstedt et al. (2019)
\doi{10.1371/journal.pone.0212110}.
}
\examples{
## calculate homogeneity of arbitrary GLCM
# define arbitrary GLCM
x <- matrix(1:16, nrow = 4)

# normalize
n_x <- normalize_glcm(x)

# calculate homogeneity
homogeneity(n_x)

## calculate homogeneity of arbitrary fitness landscape
# create fitness landscape using FitLandDF object
vals <- runif(64)
vals <- array(vals, dim = rep(4, 3))
my_landscape <- fitscape::FitLandDF(vals)

# calculate homogeneity of fitness landscape, assuming 2 discrete gray levels
homogeneity(my_landscape, nlevels = 2)

## confirm value of homogeneity for fitness landscape
# extract normalized GLCM from fitness landscape
my_glcm <- get_comatrix(my_landscape, discrete = equal_discrete(2))

# calculate homogeneity of extracted GLCM
homogeneity(my_glcm)  # should match value of above homogeneity function call
}
