% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto-generated-cli-doc-stubs.R
\name{guild_run_cli}
\alias{guild_run_cli}
\title{guild_run_cli
Run an operation.}
\usage{
guild_run_cli(
  ...,
  label = NULL,
  tag = NULL,
  comment = NULL,
  run_dir = NULL,
  stage = NA,
  start = NULL,
  restart = NULL,
  proto = NULL,
  force_sourcecode = NA,
  gpus = NULL,
  no_gpus = NA,
  batch_label = NULL,
  batch_tag = NULL,
  batch_comment = NULL,
  optimizer = NULL,
  optimize = NA,
  minimize = NULL,
  maximize = NULL,
  opt_flag = NULL,
  max_trials = NULL,
  trials = NULL,
  stage_trials = NA,
  remote = NULL,
  force_flags = NA,
  force_deps = NA,
  stop_after = NULL,
  fail_on_trial_error = NA,
  needed = NA,
  background = NA,
  pidfile = NULL,
  no_wait = NA,
  save_trials = NULL,
  keep_run = NA,
  keep_batch = NA,
  dep = NULL,
  quiet = NA,
  print_cmd = NA,
  print_env = NA,
  print_trials = NA,
  help_model = NA,
  help_op = NA,
  test_output_scalars = NULL,
  test_sourcecode = NA,
  test_flags = NA
)
}
\arguments{
\item{...}{passed on to the \code{guild} executable. Arguments are automatically quoted with \code{shQuote()}, unless they are protected with \code{I()}. Pass \code{'--help'} or \code{help = TRUE} to see all options.}

\item{label}{Set a label for the run.}

\item{tag}{Associate TAG with run. May be used multiple times.}

\item{comment}{Comment associated with the run.}

\item{run_dir}{Use alternative run directory DIR. Cannot be used with \code{stage}.}

\item{stage}{(bool) Stage an operation.}

\item{start}{Start a staged run or restart an existing run. Cannot be used with \code{proto} or \code{run_dir}.}

\item{restart}{Start a staged run or restart an existing run. Cannot be used with \code{proto} or \code{run_dir}.}

\item{proto}{Use the operation, flags and source code from RUN. Flags may be added or redefined in this operation. Cannot be used with \code{restart}.}

\item{force_sourcecode}{(bool) Use working source code when \code{restart} or \code{proto} is specified. Ignored otherwise.}

\item{gpus}{Limit availabe GPUs to DEVICES, a comma separated list of device IDs. By default all GPUs are available. Cannot beused with \code{no_gpus}.}

\item{no_gpus}{(bool) Disable GPUs for run. Cannot be used with \code{gpus}.}

\item{batch_label}{Label to use for batch runs. Ignored for non-batch runs.}

\item{batch_tag}{Associate TAG with batch. Ignored for non-batch runs. May be used multiple times.}

\item{batch_comment}{Comment associated with batch.}

\item{optimizer}{Optimize the run using the specified algorithm. See Optimizing Runs for more information.}

\item{optimize}{(bool) Optimize the run using the default optimizer.}

\item{minimize}{Column to minimize when running with an optimizer. See help for compare command for details specifying a column. May not be used with \code{maximize}.}

\item{maximize}{Column to maximize when running with an optimizer. See help for compare command for details specifying a column. May not be used with \code{minimize}.}

\item{opt_flag}{Flag for OPTIMIZER. May be used multiple times.}

\item{max_trials}{Maximum number of trials to run in batch operations. Default is optimizer specific. If optimizer is not specified, default is 20.}

\item{trials}{Maximum number of trials to run in batch operations. Default is optimizer specific. If optimizer is not specified, default is 20.}

\item{stage_trials}{(bool) For batch operations, stage trials without running them.}

\item{remote}{Run the operation remotely.}

\item{force_flags}{(bool) Accept all flag assignments, even for undefined or invalid values.}

\item{force_deps}{(bool) Continue even when a required resource is not resolved.}

\item{stop_after}{Stop operation after N minutes.}

\item{fail_on_trial_error}{(bool) Stop batch operations when a trial exits with an error.}

\item{needed}{(bool) Run only if there is not an available matching run. A matching run is of the same operation with the same flag values that is not stopped due to an error.}

\item{background}{(bool) Run operation in background.}

\item{pidfile}{Run operation in background, writing the background process ID to PIDFILE.}

\item{no_wait}{(bool) Don't wait for a remote operation to complete. Ignored if run is local.}

\item{save_trials}{Saves generated trials to a CSV batch file. See BATCH FILES for more information.}

\item{keep_run}{(bool) Keep run even when configured with 'delete-on-success'.}

\item{keep_batch}{(bool) Keep batch run rather than delete it on success.}

\item{dep}{Include PATH as a dependency.}

\item{quiet}{(bool) Do not show output.}

\item{print_cmd}{(bool) Show operation command and exit.}

\item{print_env}{(bool) Show operation environment and exit.}

\item{print_trials}{(bool) Show generated trials and exit.}

\item{help_model}{(bool) Show model help and exit.}

\item{help_op}{(bool) Show operation help and exit.}

\item{test_output_scalars}{Test output scalars on output. Use '-' to read from standard intput.}

\item{test_sourcecode}{(bool) Test source code selection.}

\item{test_flags}{(bool) Test flag configuration.}
}
\description{
By default Guild tries to run \code{OPERATION} for the default model
defined in the current project.
}
\details{
If \code{MODEL} is specified, Guild uses it instead of the default
model.

\code{OPERATION} may alternatively be a Python script. In this case any
current project is ignored and the script is run directly. Options
in the format \code{--NAME=VAL} can be passed to the script using
flags (see below).

\verb{[MODEL]:OPERATION} may be omitted if \code{restart} or \code{proto} is
specified, in which case the operation used in \code{RUN} is used.

Specify \code{FLAG} values in the form \code{FLAG=VAL}.
\subsection{Batch Files}{

One or more batch files can be used to run multiple trials by
specifying the file path as \verb{@PATH}.

For example, to run trials specified in a CSV file named
\code{trials.csv}, run:

\if{html}{\out{<div class="sourceCode">}}\preformatted{guild run [MODEL:]OPERATION @trials.csv
}\if{html}{\out{</div>}}

NOTE: At this time you must specify the operation with batch files
\itemize{
\item batch files only contain flag values and cannot be used to run
different operations for the same command.
}

Batch files may be formatted as CSV, JSON, or YAML. Format is
determined by the file extension.

Each entry in the file is used as a set of flags for a trial run.

CSV files must have a header row containing the flag names. Each
subsequent row is a corresponding list of flag values that Guild
uses for a generated trial.

JSON and YAML files must contain a top-level list of flag-to-value
maps.

Use \code{print_trials} to preview the trials run for the specified
batch files.
}

\subsection{Flag Lists}{

A list of flag values may be specified using the syntax
\verb{[VAL1[,VAL2]...]}. Lists containing white space must be
quoted. When a list of values is provided, Guild generates a trial
run for each value. When multiple flags have list values, Guild
generates the cartesian product of all possible flag combinations.

Flag lists may be used to perform grid search operations.

For example, the following generates four runs for operation
\code{train} and flags \code{learning-rate} and \code{batch-size}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{guild run train learning-rate[0.01,0.1] batch-size=[10,100]
}\if{html}{\out{</div>}}

You can preview the trials generated from flag lists using
\code{print_trials}. You can save the generated trials to a batch
file using \code{save_trials}. For more information, see PREVIEWING
AND SAVING TRIALS below.

When \code{optimizer} is specified, flag lists may take on different
meaning depending on the type of optimizer. For example, the
\code{random} optimizer randomly selects values from a flag list,
rather than generate trials for each value. See OPTIMIZERS for
more information.
}

\subsection{Optimizers}{

A run may be optimized using \code{optimizer}. An optimizer runs up
to \code{max_trials} runs using flag values and flag configuration.

For details on available optimizers and their behavior, refer to
https://guild.ai/optimizers/.
}

\subsection{Limit Trials}{

When using flag lists or optimizers, which generate trials, you
can limit the number of trials with \code{max_trials}. By default,
Guild limits the number of generated trials to 20.

Guild limits trials by randomly sampling the maximum number from
the total list of generated files. You can specify the seed used
for the random sample with \code{random_seed}. The random seed is
guaranteed to generate consistent results when used on the same
version of Python. When used across different versions of Python,
the results may be inconsistent.
}

\subsection{Preview or Save Trials}{

When flag lists (used for grid search) or an optimizer is used,
you can preview the generated trials using \code{print_trials}. You
can save the generated trials as a CSV batch file using
\code{save_trials}.
}

\subsection{Start an Operation Using a Prototype Run}{

If \code{proto} is specified, Guild applies the operation, flags, and
source code used in \code{RUN} to the new operation. You may add or
redefine flags in the new operation. You may use an alternative
operation, in which case only the flag values and source code from
\code{RUN} are applied. \code{RUN} must be a run ID or unique run ID prefix.
}

\subsection{Restart an Operation}{

If \code{restart} is specified, \code{RUN} is restarted using its
operation and flags. Unlike \code{proto}, restart does not create a
new run. You cannot change the operation, flags, source code, or
run directory when restarting a run.
}

\subsection{Staging an Operation}{

Use \code{stage} to stage an operation to be run later. Use \code{start}
with the staged run ID to start it.

If \code{start} is specified, \code{RUN} is started using the same rules
applied to \code{restart} (see above).
}

\subsection{Alternate Run Directory}{

To run an operation outside of Guild's run management facility,
use \code{run_dir} or \code{stage-dir} to specify an alternative run
directory. These options are useful when developing or debugging
an operation. Use \code{stage-dir} to prepare a run directory for an
operation without running the operation itself. This is useful
when you want to verify run directory layout or manually run an
operation in a prepared directory.

\strong{NOTE:} Runs started with \code{run_dir} are not visible to Guild
and do not appear in run listings.
}

\subsection{Control Visible GPUs}{

By default, operations have access to all available GPU
devices. To limit the GPU devices available to a run, use
\code{gpus}.

For example, to limit visible GPU devices to \code{0} and \code{1}, run:

\if{html}{\out{<div class="sourceCode">}}\preformatted{guild run gpus 0,1 ...
}\if{html}{\out{</div>}}

To disable all available GPUs, use \code{no_gpus}.

\strong{NOTE:} \code{gpus} and \code{no_gpus} are used to construct the
\code{CUDA_VISIBLE_DEVICES} environment variable used for the run
process. If \code{CUDA_VISIBLE_DEVICES} is set, using either of these
options redefines that environment variable for the run.
}

\subsection{Optimize Runs}{

Use \code{optimizer} to run the operation multiple times in attempt
to optimize a result. Use \code{minimize} or \code{maximize} to indicate
what should be optimized. Use \code{--max-runs} to indicate the maximum
number of runs the optimizer should generate.
}

\subsection{Edit Flags}{

Use \code{edit_flags} to use an editor to review and modify flag
values. Guild uses the editor defined in \code{VISUAL} or \code{EDITOR}
environment variables. If neither environment variable is defined,
Guild uses an editor suitable for the current platform.
}

\subsection{Debug Source Code}{

Use \code{debug_sourcecode} to specify the location of project source
code for debugging. Guild uses this path instead of the location
of the copied soure code for the run. For example, when debugging
project files, use this option to ensure that modules are loaded
from the project location rather than the run directory.
}

\subsection{Breakpoints}{

Use \code{break} to set breakpoints for Python based operations.
\code{LOCATION} may be specified as \verb{[FILENAME:]LINE} or as
\code{MODULE.FUNCTION}.

If \code{FILENAME} is not specified, the main module is assumed. Use
the value \code{1} to break at the start of the main module (line 1).

Relative file names are resolved relative to the their location in
the Python system path. You can omit the \code{.py} extension.

If a line number does not correspond to a valid breakpoint, Guild
attempts to set a breakpoint on the next valid breakpoint line in
the applicable module.
}
}
\keyword{internal}
