% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_guild}
\alias{install_guild}
\title{Install guildai core}
\usage{
install_guild(guildai = "guildai", python = find_python())
}
\arguments{
\item{guildai}{Character vector of arguments passed directly to \verb{pip install}. To install the release version of guildai, this can be
\code{"guildai"}. Special values of \code{"release"} and \code{"dev"} are also accepted.}

\item{python}{Path to a python binary, used to create a private isolated venv.}
}
\value{
path to the \code{guild} executable
}
\description{
This installs the \code{guild} executable for use by the R package. It creates
an isolated python virtual environment private to the R package and installs
guildai into it. Repeated calls to \code{install_guild()} result in a
fresh installation.
}
\details{
It requires that a suitable python version is
available on the system.
}
\note{
\code{install_guild()} installs guild as an isolated VM. For guild to
run a python operation, the python package \code{guildai} must be installed
in the python library where it will be used, E.g., with \verb{pip install guildai}
or \code{reticulate::py_install()}.
}
\examples{
\dontrun{
## Install release version:
install_guild()

## Install release version using a specific python
# path_to_python <- reticulate::install_python() # path to python executable
install_guild("guildai", python = path_to_python)

## Install development version
install_guild(guildai = "dev", python = path_to_python)

## Install development version from URL
 install_guild(
   guildai = "https://api.github.com/repos/guildai/guildai/tarball/HEAD",
   python = path_to_python)

## Install local development version:
install_guild(c("-e", "~/guild/guildai"))
}
}
