% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{get_best_stories}
\alias{get_best_stories}
\title{Hacker News best stories}
\usage{
get_best_stories(max_items = NULL)
}
\arguments{
\item{max_items}{Maximum number of items to retrieve.
If max_items = NULL, returns all available}
}
\value{
list of best stories
}
\description{
Retrieves best stories using Hacker News API
}
\examples{

\donttest{
# get the best story on Hacker News
best_story <- get_best_stories(max_items = 1)
best_story

# get top 20 best stories on Hacker News
best_20_stories <- get_best_stories(max_items = 20)
best_20_stories

# get all best stories on Hacker News
best_stories <- get_best_stories()
best_stories
}
}
