% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.nc.hdqr-methods.R
\name{coef.cv.nc.hdqr}
\alias{coef.cv.nc.hdqr}
\title{Extract Coefficients from a \code{cv.nc.hdqr} Object}
\usage{
\method{coef}{cv.nc.hdqr}(object, s = c("lambda.1se", "lambda.min"), ...)
}
\arguments{
\item{object}{A fitted \code{cv.nc.hdqr} object from which coefficients are to be extracted.}

\item{s}{Specifies the \code{lambda} values at which coefficients are requested.
The default is \code{s = "lambda.1se"}, representing the largest \code{lambda} such that the cross-validation
error estimate is within one standard error of the minimum. Alternatively, \code{s = "lambda.min"}
corresponds to the \code{lambda} yielding the minimum cross-validation error. If \code{s} is numeric, these
values are directly used as the \code{lambda} values for coefficient extraction.}

\item{...}{Not used.}
}
\value{
Returns a vector or matrix of coefficients corresponding to the specified `lambda` values.
}
\description{
Retrieves coefficients at specified values of \code{lambda} from a fitted \code{cv.nc.hdqr} model.
Utilizes the stored \code{nchdqr.fit} object and the optimal \code{lambda} values determined during
the cross-validation process.
}
\examples{
set.seed(315)
n <- 100
p <- 400
x <- matrix(data = rnorm(n * p, mean = 0, sd = 1), nrow = n, ncol = p)
beta_star <- c(c(2, 1.5, 0.8, 1, 1.75, 0.75, 0.3), rep(0, (p - 7)))
eps <- rnorm(n, mean = 0, sd = 1)
y <- x \%*\% beta_star + eps
tau <- 0.5
lam2 <- 0.01
lambda <- 10^(seq(1,-4, length.out=30))
\donttest{cv.nc.fit <- cv.nc.hdqr(x = x, y = y, tau = tau, lambda = lambda, lam2 = lam2)}
\donttest{coef(cv.nc.fit, s = c(0.02, 0.03))}
}
\seealso{
\code{\link{cv.nc.hdqr}}, \code{\link{predict.cv.nc.hdqr}}
}
