% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.n2.R
\name{prepare_heatmap_data2}
\alias{prepare_heatmap_data2}
\title{Function to prepare data for a heatmap: scaling, dendrograms, ...}
\usage{
prepare_heatmap_data2(
  x,
  labRow = NA,
  labCol = NA,
  Rowv = NULL,
  Colv = NULL,
  reorder = c(TRUE, TRUE),
  distfun = dist,
  hclustfun = hclust,
  rowMembers = NULL,
  colMembers = NULL,
  spacer = 1,
  scale = "none",
  trim = NULL,
  zlim = NULL,
  col = NULL,
  filter = c(TRUE, TRUE),
  add.sig = FALSE,
  pv = NULL
)
}
\arguments{
\item{x}{(\code{numeric}). Numeric matrix.}

\item{labRow}{(\code{character}). Custom row labels.}

\item{labCol}{(\code{character}). Custom column labels.}

\item{Rowv}{(\code{dendrogram} or \code{integer}). Custom dendrogram object or integer vector giving the ordering index for rows.}

\item{Colv}{(\code{dendrogram} or \code{integer}). Custom dendrogram object or integer vector giving the ordering index for columns}

\item{reorder}{(\code{logical}). Boolean of length 2 for rows and columns. Should rows and/or columns be reordered according to \code{Rowv}/\code{Colv}?}

\item{distfun}{(\code{function}). Distance function. Defaults to \code{\link[stats]{dist}}.}

\item{hclustfun}{(\code{function}). Hierarchical clustering function. Defaults to \code{\link[stats]{hclust}}.}

\item{rowMembers}{(\code{character}). Group vector to split rows by.}

\item{colMembers}{(\code{character}). Group vector to split columns by.}

\item{spacer}{(\code{integer}). Length 1 integer used as spacer to separate groups (see \code{rowMembers}/\code{colMembers}). Defaults to 1.}

\item{scale}{(\code{character}). One of "row", "column" or "none": By which dimension should data be scaled? Defaults to "none".}

\item{trim}{(\code{numeric}). Value to "cut off" data distribution. Values and both ends of the distribution, larger or smaller, respectively, will be made equal to \code{+/-trim}. Defaults to \code{NULL}, no trimming.}

\item{zlim}{(\code{numeric}). Value to set the ranges for plotting \code{x} and \code{y} values. Supports both symmetrical (with default \code{NULL}) and asymmetrical (\code{NA}) automatic \code{zlim.} Used for zooming.}

\item{col}{(\code{character}) Name (acronym) of the colour palette to use. Can be one of "RdBkGn" (c("green", "black", "red")), "BuYl" (c("blue", "yellow")), "BuWtRd" (c("blue", "white", "red")) or a valid name used by \code{\link[RColorBrewer]{brewer.pal}}. Defaults to NULL which will set "RdBkGn".}

\item{filter}{(\code{integer} or \code{logical}.) For filtering rows/columns: TRUE (=1.0) = remove rows/columns with only NAs, 0.5 = remove if >= 50 per cent NAs, etc. Defaults to \code{c(TRUE, TRUE)}.}

\item{add.sig}{(\code{logical}). Should significance asterixes be drawn?}

\item{pv}{(\code{numeric}). Matrix of the same dimensions as \code{x} with P-Values for correlation significance.}
}
\description{
Function to prepare data for a heatmap: scaling, dendrograms, ...
}
\details{
This function is used by \code{heatmap.n2} and should not be called bu the user directly. It is only documented because its arguments are passed by the main function when given there.
}
