% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading-animations.R
\name{spinner}
\alias{spinner}
\alias{render.spinner}
\title{Creates an animated spinner}
\usage{
spinner(format = "|/-\\\\", refresh = 200)

\method{render}{spinner}(object, ...)
}
\arguments{
\item{format}{character vector containing the format of the animation. See 'details' for more information.}

\item{refresh}{refresh rate in milliseconds of the animation.}

\item{object}{animated spinner.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Creates an animated spinner
}
\details{
The format of the spinner simply consists of the characters in order which the spinner cycles through.
}
\examples{
\dontrun{
sp = spinner("|/-\\\\")
n_operations = 100

for(i in 1:n_operations) {
  cat("\r", render(sp),sep="")
  Sys.sleep(0.01)
}}
}
