% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_data_constructors.R
\name{GWAS_data}
\alias{GWAS_data}
\title{Creates a \code{GWAS_data} object}
\usage{
GWAS_data(dat, keep_rownames_as = NULL)
}
\arguments{
\item{dat}{Tibble, results from a GWAS analysis. See Details.}

\item{keep_rownames_as}{Character, the name of the column in which to save the
rownames of the input data-frame. Default value is \code{NULL}, i.e. rownames will
be discarded.}
}
\value{
A \code{GWAS_data} object, i.e. a tibble.
}
\description{
Creates a \code{GWAS_data} object from a tibble or data-frame of GWAS results.
}
\details{
The input data should have one row per marker, and at least the
following columns:
\itemize{
\item \code{chromosome}: character column, chromosome on which the marker is located.
\item \code{position}: numeric, the physical position of the marker along the chromosome (in bp).
\item \code{score} or \code{padj}: numeric, the GWAS score or adjusted p-value of the marker.
If column \code{score} column is missing, will be constructed as \code{-log10(padj)}.
}
}
\examples{
x <- get_example_data()

GWAS_data(x[["GWAS"]])
}
