% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_diag.R
\name{psrf.hmclearn}
\alias{psrf.hmclearn}
\title{Calculates Potential Scale Reduction Factor (psrf), also called the Rhat statistic,
from models fit via \code{mh} or \code{hmc}}
\usage{
\method{psrf}{hmclearn}(object, burnin = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{hmclearn}, usually a result of a call to \code{mh} or \code{hmc}}

\item{burnin}{optional numeric parameter for the number of initial MCMC samples to omit from the summary}

\item{...}{currently unused}
}
\value{
Numeric vector of Rhat statistics for each parameter
}
\description{
Gelman and Rubin's diagnostic assesses the mix of multiple MCMC chain with different initial parameter values
Values close to 1 indicate that the posterior simulation has sufficiently converged, while
values above 1 indicate that additional samples may be necessary to ensure convergence.  A general
guideline suggests that values less than 1.05 are good, between 1.05 and 1.10 are ok, and above 1.10
have not converged well.
}
\examples{
# poisson regression example
set.seed(7363)
X <- cbind(1, matrix(rnorm(40), ncol=2))
betavals <- c(0.8, -0.5, 1.1)
lmu <- X \%*\% betavals
y <- sapply(exp(lmu), FUN = rpois, n=1)

f <- hmc(N = 1000,
          theta.init = rep(0, 3),
          epsilon = 0.01,
          L = 10,
          logPOSTERIOR = poisson_posterior,
          glogPOSTERIOR = g_poisson_posterior,
          varnames = paste0("beta", 0:2),
          param = list(y=y, X=X),
          parallel=FALSE, chains=2)

psrf(f, burnin=100)

}
\references{
Gelman, A. and Rubin, D. (1992) \emph{Inference from Iterative Simulation Using Multiple Sequences}.  Statistical Science 7(4) 457-472.

Gelman, A., et. al. (2013) \emph{Bayesian Data Analysis}.  Chapman and Hall/CRC.

Gabry, Jonah and Mahr, Tristan (2019).  \emph{bayesplot:  Plotting for Bayesian Models}.  \url{https://mc-stan.org/bayesplot/}
}
