% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{hglmc}
\alias{hglmc}
\alias{c.hglmc}
\alias{is.hglmc}
\title{Generic Functions for \code{hglmc} Objects}
\usage{
\method{c}{hglmc}(...)

is.hglmc(x)
}
\arguments{
\item{...}{multiple objects inheriting from \code{"hglmc"} to be combined.}

\item{x}{an R object.}
}
\value{
The combine function \code{c()} returns an object of class \code{"hglmc"}.
The \code{is.hglmc} function returns \code{TRUE} if the object inherits
from class \code{"hglmc"} otherwise \code{FALSE}.
}
\description{
Generic functions for holistic 'GLM' constraints.
}
\details{
The 'HGLM' constraints are all of class \code{"hglmc"}
and can be combined with the typical combine function \code{c()}.
To verify that an object is a 'HGLM' constraint, the function
\code{is.hglmc} can be used.
}
\examples{
constraints <- c(k_max(7), pairwise_sign_coherence())
is.hglmc(constraints)
}
