% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/honda.ivive.R
\name{honda.ivive}
\alias{honda.ivive}
\title{Return the assumptions used in Honda et al. 2019}
\usage{
honda.ivive(method = "Honda1", tissue = "liver")
}
\arguments{
\item{method}{This is set to one of "Honda1", "Honda2", "Honda3", or "Honda4".}

\item{tissue}{This is only relevant to "Honda4" and indicates the relevant tissue compartment.}
}
\value{
A list of tissue, bioactive.free.invivo, and restrictive.clearance assumptions.
}
\description{
This function returns four of the better performing sets of assumptions evaluated in Honda et al. 2019 
(https://doi.org/10.1371/journal.pone.0217564).These include four different combinations of hepatic clearance assumption, in vivo bioactivity assumption, 
and relevant tissue assumption. Generally, this function is not called directly by the user, but instead
called by setting the IVIVE option in calc_mc_oral_equiv, calc_mc_css, and calc_analytic functions. Currently, these IVIVE option 
is not implemented the solve_1comp etc. functions.
}
\details{
Only four sets of IVIVE assumptions that performed well in Honda et al. 
(2019) are currently included:
"Honda1" through "Honda4". The use of max (peak)  
concentration can not be currently be calculated with \code{\link{calc_analytic_css}}. 
The httk default settings correspond to "Honda3":

\tabular{lrrrrr}{
\tab \emph{In Vivo} Conc. \tab Metabolic Clearance \tab Bioactive Chemical Conc. \emph{In Vivo} \tab TK Statistic Used* \tab Bioactive Chemical Conc. \emph{In Vitro} \cr
Honda1 \tab Veinous (Plasma) \tab Restrictive \tab Free \tab Mean Conc. In Vivo \tab Free Conc. In Vitro \cr
Honda2 \tab Veinous \tab Restrictive \tab Free \tab Mean Conc. In Vivo \tab Nominal Conc. In Vitro \cr
Honda3 \tab Veinous \tab Restrictive \tab Total \tab Mean Conc. In Vivo \tab Nominal Conc. In Vitro \cr
Honda4 \tab Target Tissue \tab Non-restrictive \tab Total \tab Mean Conc. In Vivo \tab Nominal Conc. In Vitro \cr
}

"Honda1" uses plasma concentration, restrictive clearance, and treats the 
unbound invivo concentration as bioactive. For IVIVE, any input nominal 
concentration in vitro should be converted to cfree.invitro using 
\code{\link{armitage_eval}}, otherwise performance will be the same as 
"Honda2".
}
\examples{
honda.ivive(method = "Honda1", tissue = NULL)

}
\references{
\insertRef{honda2019using}{httk}
}
\author{
Greg Honda and John Wambaugh
}
\keyword{Solve}
