% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in.list.R
\name{in.list}
\alias{in.list}
\alias{is.nhanes}
\alias{is.tox21}
\alias{is.toxcast}
\alias{is.seem}
\alias{is.pharma}
\alias{is.pfas}
\title{Convenience Boolean (yes/no) functions to identify chemical membership in
several key lists.}
\usage{
in.list(
  chem.name = NULL,
  chem.cas = NULL,
  dtxsid = NULL,
  which.list = "ToxCast"
)

is.tox21(chem.cas)

is.toxcast(chem.cas)

is.seem(chem.cas)

is.nhanes(chem.cas)

is.pharma(chem.cas)

is.pfas(chem.cas)
}
\arguments{
\item{chem.name}{One or more Chemical names (spaces and capitalization ignored) --  the 
chemical must be identified by either CAS, name, or DTXISD}

\item{chem.cas}{One or more Chemical Abstract Services Registry Numbers (CAS-RN) -- the 
chemical must be identified by either CAS, name, or DTXISD}

\item{dtxsid}{One or more of EPA's DSSTox Structure IDs (\url{https://comptox.epa.gov/dashboard})
-- the chemical must be identified by either CAS, name, or DTXSIDs}

\item{which.list}{A character string that can take the following values:
"ToxCast", "Tox21", "SEEM", "NHANES", "PFAS", "Pharma"
#'}
}
\value{
\item{logical}{A Boolean (1/0) value that is TRUE if the chemical is
in the list.}
}
\description{
These functions allow easy identification of whether or not a chemical CAS
is included in various research projects. While it is our intent to keep
these lists up-to-date, the information here is only for convenience and
should not be considered to be definitive.
}
\details{
Tox21: Toxicology in the 21st Century (Tox21) is a U.S. federal High
Throughput Screening (HTS) collaboration among EPA, NIH, including National
Center for Advancing Translational Sciences and the National Toxicology
Program at the National Institute of Environmental Health Sciences, and the
Food and Drug Administration.  (Bucher et al., 2008)

ToxCast: The Toxicity Forecaster (ToxCast) is a HTS screening project led by
the U.S. EPA to perform additional testing of a subset of Tox21 chemicals.
(Judson et al. 2010)

SEEM: Systematic Empirical Evaluation of Models is a consensus exposure
modeling prediction providing a tentative estimate of daily intake rate
in units of mg/kg BW/day for chemicals that may have little 
information on exposure (Ring et al. 2018)

NHANES: The U.S. Centers for Disease Control (CDC) National Health and
Nutrition Examination Survery (NHANES) is an on-going survey to characterize
the health and biometrics (e.g., weight, height) of the U.S. population. One
set of measurments includes the quantification of xenobiotic chemicals in
various samples (blood, serum, urine) of the thousands of surveyed
individuals. (CDC, 2014)
}
\section{Functions}{
\itemize{
\item \code{is.tox21()}: Boolean (yes/no) chemical identity functions

\item \code{is.toxcast()}: Boolean (yes/no) chemical identity functions

\item \code{is.seem()}: Boolean (yes/no) chemical identity functions

\item \code{is.nhanes()}: Boolean (yes/no) chemical identity functions

\item \code{is.pharma()}: Boolean (yes/no) chemical identity functions

\item \code{is.pfas()}: Boolean (yes/no) chemical identity functions

}}
\examples{

\donttest{
httk.table <- get_cheminfo(info=c("CAS","Compound"))
httk.table[,"Rat"] <- ""
httk.table[,"NHANES"] <- ""
httk.table[,"Tox21"] <- ""
httk.table[,"ToxCast"] <- ""
httk.table[,"ExpoCast"] <- ""
httk.table[,"PBTK"] <- ""
# To make this example run quickly, this loop is only over the first five 
# chemicals. To build a table with all available chemicals use:
# for (this.cas in httk.table$CAS)
for (this.cas in httk.table$CAS[1:5])
{
  this.index <- httk.table$CAS==this.cas
  if (is.nhanes(chem.cas=this.cas)) httk.table[this.index,"NHANES"] <- "Y"
  if (is.tox21(chem.cas=this.cas)) httk.table[this.index,"Tox21"] <- "Y"
  if (is.toxcast(chem.cas=this.cas)) httk.table[this.index,"ToxCast"] <- "Y"
  if (is.seem(chem.cas=this.cas)) httk.table[this.index,"ExpoCast"] <- "Y"
  if (is.httk(chem.cas=this.cas,model="PBTK")) httk.table[this.index,"PBTK"] <- "Y"
  if (is.httk(chem.cas=this.cas,species="rat")) httk.table[this.index,"Rat"] <- "Y"
}
}

}
\references{
Bucher, J. R. (2008). Guest Editorial: NTP: New Initiatives, New
Alignment. Environ Health Perspect 116(1).

Judson, R. S., Houck, K. A., Kavlock, R. J., Knudsen, T. B., Martin, M. T.,
Mortensen, H. M., Reif, D. M., Rotroff, D. M., Shah, I., Richard, A. M. and
Dix, D. J. (2010). In Vitro Screening of Environmental Chemicals for
Targeted Testing Prioritization: The ToxCast Project. Environmental Health
Perspectives 118(4), 485-492.

Wambaugh, J. F., Wang, A., Dionisio, K. L., Frame, A., Egeghy, P., Judson,
R. and Setzer, R. W. (2014). High Throughput Heuristics for Prioritizing
Human Exposure to Environmental Chemicals. Environmental Science &
Technology, 10.1021/es503583j.

CDC (2014). National Health and Nutrition Examination Survey. Available at:
https://www.cdc.gov/nchs/nhanes.htm.
}
\seealso{
\code{\link{is.httk}} for determining inclusion in httk project
}
\author{
John Wambaugh
}
