% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_1comp_lifestage.R
\name{solve_1comp_lifestage}
\alias{solve_1comp_lifestage}
\title{Solve \code{1comp_lifestage} model, which has time-dependent parameters}
\usage{
solve_1comp_lifestage(
  chem.name = NULL,
  chem.cas = NULL,
  dtxsid = NULL,
  times = NULL,
  parameters = NULL,
  days = 10,
  tsteps = 4,
  daily.dose = NULL,
  dose = NULL,
  doses.per.day = NULL,
  initial.values = NULL,
  plots = FALSE,
  suppress.messages = FALSE,
  species = "Human",
  iv.dose = FALSE,
  output.units = "uM",
  method = "lsoda",
  rtol = 1e-08,
  atol = 1e-12,
  default.to.human = FALSE,
  recalc.blood2plasma = FALSE,
  recalc.clearance = FALSE,
  dosing.matrix = NULL,
  adjusted.Funbound.plasma = TRUE,
  regression = TRUE,
  restrictive.clearance = T,
  minimum.Funbound.plasma = 1e-04,
  monitor.vars = NULL,
  time.varying.params = TRUE,
  start.age = 360,
  ref.pop.dt = NULL,
  httkpop.generate.arg.list = list(method = "virtual individuals", nsamp = 25000),
  ref.params = NULL,
  ...
)
}
\arguments{
\item{chem.name}{Either the chemical name, CAS number, or the parameters
must be specified.}

\item{chem.cas}{Either the chemical name, CAS number, or the parameters must
be specified.}

\item{dtxsid}{EPA's 'DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{times}{Optional time sequence for specified number of days.}

\item{parameters}{Chemical parameters from parameterize_1comp function,
overrides chem.name and chem.cas.}

\item{days}{Length of the simulation.}

\item{tsteps}{The number time steps per hour.}

\item{daily.dose}{Total daily dose, mg/kg BW.}

\item{dose}{Amount of a single dose, mg/kg BW.}

\item{doses.per.day}{Number of doses per day.}

\item{initial.values}{Vector containing the initial concentrations or
amounts of the chemical in specified tissues with units corresponding to
output.units.  Defaults are zero.}

\item{plots}{Plots all outputs if true.}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", or default
"Human").}

\item{iv.dose}{Simulates a single i.v. dose if true.}

\item{output.units}{Desired units (either "mg/L", "mg", "umol", or default
"uM").}

\item{method}{Method used by integrator (deSolve).}

\item{rtol}{Argument passed to integrator (deSolve).}

\item{atol}{Argument passed to integrator (deSolve).}

\item{default.to.human}{Substitutes missing rat values with human values if
true.}

\item{recalc.blood2plasma}{Whether or not to recalculate the blood:plasma
chemical concentration ratio}

\item{recalc.clearance}{Whether or not to recalculate the elimination
rate.}

\item{dosing.matrix}{Vector of dosing times or a matrix consisting of two
columns or rows named "dose" and "time" containing the time and amount, in
mg/kg BW, of each dose.}

\item{adjusted.Funbound.plasma}{Uses adjusted Funbound.plasma when set to
TRUE along with volume of distribution calculated with this value.}

\item{regression}{Whether or not to use the regressions in calculating
partition coefficients in volume of distribution calculation.}

\item{restrictive.clearance}{In calculating elimination rate, protein
binding is not taken into account (set to 1) in liver clearance if FALSE.}

\item{minimum.Funbound.plasma}{Monte Carlo draws less than this value are set 
equal to this value (default is 0.0001 -- half the lowest measured Fup in our
dataset).}

\item{monitor.vars}{Which variables are returned as a function of time. 
Defaults value of NULL provides "Agutlumen", "Ccompartment", "Ametabolized",
"AUC"}

\item{time.varying.params}{Whether or not to allow parameters to vary in time 
according to the nonparametric regression determined by \code{\link{get_input_param_timeseries}}. 
Default is TRUE.}

\item{start.age}{The age of the individual in months at the beginning of the
simulation. Default 360.}

\item{ref.pop.dt}{The output of \code{\link{httkpop_generate}} containing physiology
of the population used in determining timeseries of parameters. Ignored if \code{ref.params}
is given.}

\item{httkpop.generate.arg.list}{If \code{ref.pop.dt} is \code{NULL}, these arguments
are used as input to \code{\link{httkpop_generate}} for generating physiology of 
a reference population.}

\item{ref.params}{Model parameters of a reference population used in determining
timeseries. Recommended column binding ages in months (as \code{age_months}) to
the output of \code{\link{create_mc_samples}}.}

\item{...}{Additional arguments passed to the integrator.}
}
\value{
A matrix with a column for time(in days) and a column for the
compartment and the area under the curve (concentration only).
}
\description{
This function solves for the amount or concentration of a chemical in plasma
for a one compartment model as a function of time based on the dose and
dosing frequency.
}
\details{
Note that the model parameters have units of hours while the model output is
in days.

Default value of NULL for doses.per.day solves for a single dose.

When species is specified as rabbit, dog, or mouse, the function uses the
appropriate physiological data(volumes and flows) but substitutes human
fraction unbound, partition coefficients, and intrinsic hepatic clearance.

AUC is area under plasma concentration curve.

Model Figure 
\if{html}{\figure{1comp.png}{options: width=372 alt="Figure: One
Compartment Model Schematic"}}
\if{latex}{\figure{1comp.pdf}{options: width=12cm alt="Figure: One
Compartment Model Schematic"}}
}
\examples{

\donttest{

params <- parameterize_1comp(chem.name = 'Bisphenol A')

pop.phys <- httkpop_generate(method = 'virtual individuals',
                             nsamp = 25000,
                             agelim_years = c(18, 79),
                             weight_category = c("Normal"))
pop.params <- create_mc_samples(chem.name = 'Bisphenol A',
                                model = '1compartment',
                                httkpop.dt = pop.phys)
ref.params <- cbind(pop.params,
                    age_months = pop.phys$age_months)
out <- solve_1comp_lifestage(chem.name = 'Bisphenol A',
                             parameters = params,
                             days = 365,
                             start.age = 600, # age fifty
                             ref.params = ref.params,
                             doses.per.day = 3,
                             daily.dose = 1)
                              
}

}
\author{
Colin Thomson
}
\keyword{1compartment}
\keyword{Solve}
\keyword{lifestage}
