% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v3-schema-utils.R
\name{is_v3_config_file}
\alias{is_v3_config_file}
\title{Is config file using v3.0.0 schema?}
\usage{
is_v3_config_file(config_path)
}
\arguments{
\item{config_path}{Either a character string of a path to a local JSON config
file, a character string of the URL to the \strong{raw contents} of a JSON config
file (e.g on GitHub) or
an object of class \verb{<SubTreeFileSystem>} created using functions
\code{\link[arrow:s3_bucket]{arrow::s3_bucket()}} and associated methods for creating paths to JSON config
files within the bucket.}
}
\value{
Logical, whether the config file is using v3.0.0 schema or greater.
}
\description{
Is config file using v3.0.0 schema?
}
\examples{
config_path <- system.file("config", "tasks.json", package = "hubUtils")
is_v3_config_file(config_path)
}
