% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-model_out_tbl.R
\name{subset_task_id_cols}
\alias{subset_task_id_cols}
\alias{subset_std_cols}
\title{Subset a \code{model_out_tbl} or submission \code{tbl}.}
\usage{
subset_task_id_cols(model_out_tbl)

subset_std_cols(model_out_tbl)
}
\arguments{
\item{model_out_tbl}{A \code{model_out_tbl} or submission \code{tbl} object. Must inherit
from class \code{data.frame}.}
}
\value{
\itemize{
\item \code{subset_task_id_cols}: an object of the same class as \code{model_out_tbl}
which contains only task ID columns.
}

\itemize{
\item \code{subset_std_cols}: an object of the same class as \code{model_out_tbl}
which contains only hubverse standard columns (i.e. columns that are not
task_id columns).
}
}
\description{
Subset a \code{model_out_tbl} or submission \code{tbl}.
}
\section{Functions}{
\itemize{
\item \code{subset_task_id_cols()}: subset a \code{model_out_tbl} or submission
\code{tbl} to only include task_id columns

\item \code{subset_std_cols()}: subset a \code{model_out_tbl} or submission \code{tbl}
to only include hubverse standard columns (i.e. columns that are not task_id
columns)

}}
\examples{
model_out_tbl_path <- system.file("testhubs", "v4", "simple",
  "model-output", "hub-baseline", "2022-10-15-hub-baseline.parquet",
  package = "hubUtils"
)
model_out_tbl <- arrow::read_parquet(model_out_tbl_path)
subset_task_id_cols(model_out_tbl)
subset_std_cols(model_out_tbl)
}
