% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full.R
\name{generate_hybrid_ehr_dataset}
\alias{generate_hybrid_ehr_dataset}
\title{Generate synthetic hybrid EHR tables}
\usage{
generate_hybrid_ehr_dataset(
  n_patients = 500,
  n_sites = 3,
  covid_focused = TRUE,
  include_ct_links = FALSE,
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{n_patients}{Number of unique patients.}

\item{n_sites}{Number of sites/hospitals to simulate.}

\item{covid_focused}{Logical; if TRUE, use COVID-era encounter and lab patterns.}

\item{include_ct_links}{Logical; if TRUE, add CT timing variables and a CT
severity score in the CT research view.}

\item{seed}{Optional integer used to set the random seed for reproducibility.}

\item{verbose}{Logical; if TRUE, print progress messages to the console.}
}
\value{
A list with elements:
\describe{
\item{tables}{Named list of core EHR tables (patients, encounters, vitals,
labs, medications, procedures, allergies).}
\item{research}{Named list with \code{ct_research_view} (if covid_focused) and
\code{ml_flat_view} (aggregated ML-ready table).}
\item{metadata}{List of high-level generation settings and table metadata.}
}
}
\description{
Generate synthetic hybrid EHR tables
}
\examples{
ehr <- generate_hybrid_ehr_dataset(
  n_patients = 10,
  n_sites = 2,
  covid_focused = TRUE,
  include_ct_links = FALSE,
  seed = 123,
  verbose = FALSE
)

names(ehr$tables)
head(ehr$tables$patients)

}
