% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/River_Engineering.R
\name{filterlayer}
\alias{filterlayer}
\title{Calculate grain size distribution of a filter layer}
\usage{
filterlayer(
  d15B,
  d50B,
  d15U,
  d50U,
  d85U,
  dmax = 400,
  plot = TRUE,
  fuller = FALSE
)
}
\arguments{
\item{d15B}{Numeric. d15 of block [mm].}

\item{d50B}{Numeric. d50 of block [mm].}

\item{d15U}{Numeric. d15 of soil [mm].}

\item{d50U}{Numeric. d50 of soil [mm].}

\item{d85U}{Numeric. d85 of soil [mm].}

\item{dmax}{Numeric. Maximum grain diameter of filter layer [mm].}

\item{plot}{Logical. If TRUE, the results are plotted (default is TRUE).}

\item{fuller}{Logical. If TRUE, adds curves of Fuller distributions with
exponents 0.5 < q < 1.5 to the plot. For an ideal grain size distribution,
q is estimated as 0.5 (default is FALSE).}
}
\value{
A list with the following components:
  \item{d15min}{Minimum d15 of filter layer [mm].}
  \item{d15max}{Maximum d15 of filter layer [mm].}
  \item{d50min}{Minimum d50 of filter layer [mm].}
  \item{d50max}{Maximum d50 of filter layer [mm].}
  \item{d85min}{Minimum d85 of filter layer [mm].}
}
\description{
Tool to calculate the range of the grain size distribution of a filter layer.
}
\examples{
# Calculate range of the grain size distribution
filterlayer(1000, 1500, 5, 10, 20, 400)

# Calculate range of the grain size distribution and add Fuller curves
filterlayer(1000, 1500, 5, 10, 20, 400, fuller = TRUE)

}
