% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.hydra.R
\name{plot.hydra}
\alias{plot.hydra}
\title{Plot a hyperbolic embedding}
\usage{
\method{plot}{hydra}(x, labels = NULL, node.col = 1, pch = NULL,
  graph.adj = NULL, crop.disc = TRUE, shrink.disc = FALSE,
  disc.col = "grey90", rotation = 0, mark.center = 0,
  mark.angles = 0, mildify = 3, cex = 1, ...)
}
\arguments{
\item{x}{a hydra object as returned by \code{\link{hydra}} with dimension \code{dim} equal 2}

\item{labels}{character labels for the embedded points, supplied as a vector. NULL triggers default values}

\item{node.col}{colors for the labels and/or points, supplied as a vector. NULL triggers default values. See `Color Specification' in \code{\link[graphics]{par}} for details}

\item{pch}{plotting 'characters' for the embedded points. supplied as a vector. NULL triggers default values. See \code{\link[graphics]{points}} for details}

\item{graph.adj}{a graph adjacency matrix that is used to plot links between the embedded points (links are drawn for all non-zero elements of \code{graph.adj})}

\item{crop.disc}{should the Poincare disc be cropped or fully shown? Defaults to TRUE}

\item{shrink.disc}{if true, the Poincare disc is shrunk to tightly fit all plotted points. Defaults to FALSE}

\item{disc.col}{color of the Poincare disc. Set to "white" to hide disc}

\item{rotation}{rotate points by this angle (specified in degrees) around the center of the Poincare disc}

\item{mark.center}{Should a cross be placed at the center of the disc? If 0, nothing is drawn. Other values specify the relative size of the cross mark.}

\item{mark.angles}{Should the angular coordinates of points be marked at the boundary of the disc? If 0, nothing is drawn. Other values specify the relative size of the angle marks.}

\item{mildify}{large values reduce the curvature of links. Values around 3 are visually most appealing. Setting \code{mildify} to 1 shows the true hyperbolic curvature}

\item{cex}{character expansion for labels and points, supplied as a numerical vector. See also \code{\link[graphics]{points}}}

\item{...}{all other parameters are passed on as additional graphical parameters (see \code{\link[graphics]{par}})}
}
\description{
Plot a two-dimensional hyperbolic embedding as returned by \code{\link{hydra}} in the Poincare disc
}
\examples{
data(karate)
embedding <- hydra(karate$distance)
plot(embedding,labels=karate$label,node.col=karate$group,graph.adj=karate$adjacency)

# plot points instead of labels, hide Poincare disc and rotate by 90 degrees:
plot(embedding,pch=karate$group, node.col=karate$group,graph.adj=karate$adjacency, disc.col="white",
     rotation=90)

# do not crop the Poincare disc, mark the center and mark angles:
plot(embedding,labels=karate$label, node.col=karate$group,graph.adj=karate$adjacency,
     crop.disc=FALSE, mark.center=0.05, mark.angles=0.025)

}
\author{
Martin Keller-Ressel <martin.keller-ressel@tu-dresden.de>
}
