% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_graphs.R
\name{check_graph}
\alias{check_graph}
\alias{check_single_graph}
\title{Parameter checking for a graph-pair}
\usage{
check_graph(
  A,
  B,
  same_order = TRUE,
  square = TRUE,
  as_list = TRUE,
  as_igraph = FALSE
)

check_single_graph(A, square = TRUE, as_list = TRUE, as_igraph = FALSE)
}
\arguments{
\item{A}{A matrix, an igraph object, or list of either.}

\item{B}{A matrix, an igraph object, or list of either.}

\item{same_order}{Whether the returned objects should have the same number of nodes.
If the graphs start with different numbers of nodes the smaller graph is padded with
isolated vertices. (default = TRUE)}

\item{square}{Whether the matrices need to be square. (default = TRUE)
Currently non-square matrices are not supported.}

\item{as_list}{Whether to return the results as a matrix_list. (default = TRUE)
If FALSE and A and B have length > 1}

\item{as_igraph}{Whether to return an igraph object. (default=FALSE)
Only allowed if the original parameters are igraph objects.
If FALSE, then this converts the objects to sparse matrices.}
}
\value{
List containing A and B modified according to the parameters and the number of 
 vertices in each graph in totv1 and totv2.
}
\description{
Function that checks that the pair of graphs passed
 to a matching-related functions satisfies necessary conditions and modifies
 them according to specified parameters. check_single_graph
 does similar checks and modifications but just for one graph or list of graphs.
}
\details{
If A and B are lists of matrices or igraph objects, then the lists
 must be the same length. Additionally, within each list the graphs need to have the
 same number of vertices but this does not need to be true across lists.
}
