% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histogramArray.R
\name{histogramArray}
\alias{histogramArray}
\title{Histogram Array}
\usage{
histogramArray(x, n = 7, env = parent.frame())
}
\arguments{
\item{x}{an \code{lm} or \code{svyglm} object.}

\item{n}{the number of additional histograms to plot alongside the original.}

\item{env}{environment for finding data to bootstrap}
}
\value{
No return value, called to generate plot.
}
\description{
Produces an array of histograms to compare against the histogram of
residuals for a fitted linear model.
}
\details{
The histogram of the model \code{x} appears in the top-left
position. For each of the other histograms, the fitted values of
\code{x} are taken and normal random errors are added to these. The
normal residual standard errors have standard error equal to the
estimated residual standard error of \code{x}. A model is then fitted
to this altered data and a histogram is produced.
}
\examples{
histogramArray(lm(Sepal.Length ~ Sepal.Width + Species, data = iris))
}
\seealso{
\code{\link{iNZightQQplot}}
}
\author{
David Banks, Tom Elliott
}
