% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{rv.link.significance}
\alias{rv.link.significance}
\title{Wrapper function to determine significance in the PC algorithm}
\usage{
rv.link.significance(a, b, set, suffStat)
}
\arguments{
\item{a}{Either an index or a string to identify dataset a.}

\item{b}{Either an index or a string to identify dataset b.}

\item{set}{Datasets that need to be partialized for. Set to NULL if there are none (i.e. if you're computing a regular, non-partial RV).
If set consists of one dataset, then provide an index or a string to identify set.
If set consists of multiple datasets, then provide a vector of indices or a vector of strings.}

\item{suffStat}{A named list with two items: cors, which is the result from rv.cor.matrix(); and cors_perm, which is the result from run.permutations().}
}
\value{
The p-value.
}
\description{
This function is a wrapper function around rv.pval(), such that it
can easily be used with pc() from the pcalg package. If you have trouble installing the pcalg package, have a look at our vignette 'A quick start to iTOP'.
}
\examples{
set.seed(2)
n = 100
p = 100
x1 = matrix(rnorm(n*p), n, p)
x2 = x1 + matrix(rnorm(n*p), n, p)
x3 = x2 + matrix(rnorm(n*p), n, p)
data = list(x1=x1, x2=x2, x3=x3)
config_matrices = compute.config.matrices(data)
cors = rv.cor.matrix(config_matrices)
cors_perm = run.permutations(config_matrices, nperm=1000)

\dontrun{
library(pcalg)
suffStat = list(cors=cors, cors_perm=cors_perm)
pc.fit = pc(suffStat=suffStat, indepTest=rv.link.significance, labels=names(data),
            alpha=0.05, conservative=TRUE, solve.confl=TRUE)
plot(pc.fit, main="")}
}
