% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClaimsByWaitTime.R
\name{claims_by_wait_time}
\alias{claims_by_wait_time}
\title{claims_by_wait_time}
\usage{
claims_by_wait_time(
  tbl_policy,
  claim_frequency,
  payment_frequency,
  occurrence_wait,
  report_wait,
  pay_wait,
  pay_severity,
  pay_only_positive = TRUE
)
}
\arguments{
\item{tbl_policy}{A data frame of policy records}

\item{claim_frequency}{Number of claims per policy; can be a distribution.}

\item{payment_frequency}{Number of payments per claim; can be a distribution.}

\item{occurrence_wait}{Time until occurrence for each claim; can be a distribution}

\item{report_wait}{Time until report; can be a distribution.}

\item{pay_wait}{Lag time between payments; can be a distribution.}

\item{pay_severity}{Severity of each claim payment; can be a distribution.}

\item{pay_only_positive}{Boolean indicating whether to discard negative payments.}
}
\value{
A data frame, as follows:
\describe{
  \item{policy_effective_date}{Date}
  \item{policy_expiration_date}{Date}
  \item{exposure}{double}
  \item{policyholder_id}{integer}
  \item{claim_id}{integer}
  \item{occurrence_date}{Date}
  \item{report_date}{Date}
  \item{number_of_payments}{integer}
  \item{payment_date}{Date}
  \item{payment_amount}{double}
}
}
\description{
Construct a data frame of claims simulated by time between events.
}
\details{
This function will generate claim transactions. Wait times and frequencies will
be converted to integers with no message. If wait times or claim frequencies
are less than zero, or payment frequencies are less than one, they will be converted with a message.
}
