% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_VAR_t.R
\name{fit_VAR_t}
\alias{fit_VAR_t}
\title{Fit Student's t VAR model to time series with missing values and/or outliers}
\usage{
fit_VAR_t(
  Y,
  p = 1,
  omit_missing = FALSE,
  parallel_max_cores = max(1, parallel::detectCores() - 1),
  verbose = FALSE,
  return_iterates = FALSE,
  initial = NULL,
  L = 10,
  maxiter = 50,
  ptol = 0.001,
  partition_groups = TRUE,
  K = round(maxiter/3)
)
}
\arguments{
\item{Y}{Time series object coercible to either a numeric matrix (e.g., \code{zoo} or \code{xts}) with missing values denoted by \code{NA}.}

\item{p}{Positive integer indicating the order of the VAR model.}

\item{omit_missing}{Logical value indicating whether to use the omit-variable method, i.e., 
excluding the variables with missing data from the analysis (default is \code{FALSE}).}

\item{parallel_max_cores}{Positive integer indicating the maximum numer of cores used in the parallel computing, 
only valid when \code{partition_groups} = \code{TRUE} (default is \eqn{1}).}

\item{verbose}{Logical value indicating whether to report in console the information of each iteration.}

\item{return_iterates}{Logical value indicating whether to return the parameter estimates at each iteration (default is \code{FALSE}).}

\item{initial}{List with the initial values of the parameters of the VAR model, which may contain some or all of the following elements:
\itemize{\item{\code{nu} (\eqn{\nu}) - a positive number as the degrees of freedom,}
         \item{\code{phi0} (\eqn{\phi_0}) - a numerical vector of length \code{ncol(Y)} as the interception of VAR model,}
         \item{\code{Phii} (\eqn{\Phi_i}) - a list of \code{p} matrices of dimension \code{ncol(Y)} as the autoregressive coefficient matrices,}
         \item{\code{scatter} (\eqn{\Sigma}) - a positive definite of dimension \code{ncol(Y)} as the scatter matrix.}}}

\item{L}{Positive integer with the number of Markov chains (default is \eqn{10}).}

\item{maxiter}{Positive integer with the number of maximum iterations (default is \eqn{100}).}

\item{ptol}{Non-negative number with the tolerance to determine the convergence of the (stochastic) EM method.}

\item{partition_groups}{Logical value indicating whether to partition \code{Y} into groups (default is \code{TRUE}).}

\item{K}{Positive integer indicating the values of the step sizes in the stochastic EM method.}
}
\value{
A list with the following elements:
\item{\code{nu}}{The estimate for \eqn{\nu}.}
\item{\code{phi0}}{The estimate for \eqn{\phi_0}.}
\item{\code{Phii}}{The estimate for \eqn{\Phi_i}.}
\item{\code{scatter}}{The estimate for scatter matrix, i.e., \eqn{\Sigma}.}

\item{\code{converged}}{A logical value indicating whether the method has converged.}
\item{\code{iter_usage}}{A number indicating how many iteration has been used.}
\item{\code{elapsed_times}}{A numerical vector indicating how much is comsumed in each iteration.}
\item{\code{elapsed_time}}{A number indicating how much time is comsumed overall.}
\item{\code{elapsed_time_per_iter}}{A number indicating how much time is comsumed for each iteration in average.}
\item{\code{iterates_record}}{A list as the records of parameter estimates of each iteration, only returned when \code{return_iterates} = \code{TRUE}.}
}
\description{
Estimate the parameters of a Student's t vector autoregressive
             model 
             \deqn{y_t = \phi_0 + \sum_{i=1}^p \Phi_i * y_{t-i} + \epsilon_t}
             to fit the given time series with missing values. 
             If the time series does not contain missing values, the 
             maximum likelihood (ML) estimation is done via the iterative
             EM algorithm until converge is achieved.
             With missing values, the stochastic EM algorithm is employed 
             for the estimation (currently the maximum number of iterations
             will be executed without attempting to check early converge).
}
\examples{
\donttest{
library(imputeFin)
data(ts_VAR_t)
fitted <- fit_VAR_t(Y = ts_VAR_t$Y, p = 2, parallel_max_cores = 2)
}

}
\references{
R. Zhou, J. Liu, S. Kumar, and D. P. Palomar, "Student’s t VAR Modeling with Missing Data via 
Stochastic EM and Gibbs Sampling," IEEE Trans. on Signal Processing, vol. 68, pp. 6198-6211, Oct. 2020.
}
\seealso{
\code{\link{fit_AR1_t}}
}
\author{
Rui Zhou and Daniel P. Palomar
}
