% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_detect.R
\name{out}
\alias{out}
\alias{\%out\%}
\title{Detect values that don't match}
\usage{
x \%out\% table
}
\arguments{
\item{x}{vector of values to be matched.}

\item{table}{vector or list to be matched against.}
}
\value{
a logical vector or of the same length as \code{x}
indicating if each value of \code{x} is within the defined subset.
}
\description{
\code{\%out\%} is the negation of \code{\%in\%}, so \code{x \%out\% y} is equivalent to \code{! x \%in\% y}.
}
\examples{
iris$Species \%in\% c("setosa", "versicolor")
iris$Species \%out\% c("setosa", "versicolor")

}
\seealso{
\code{\%in\%}
}
