% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-coerce.R
\name{type.enum}
\alias{type.enum}
\title{Define a conformance rule to match a factor with specific levels.}
\usage{
type.enum(..., .drop = FALSE, .ordered = FALSE)
}
\arguments{
\item{...}{the levels (no quotes, backticks if required)}

\item{.drop}{should levels present in the data and not specified cause an error
(FALSE the default) or be silently dropped to NA values (TRUE).}

\item{.ordered}{must the factor be ordered}
}
\value{
a function that can check and convert input into the factor with specified
levels. This will re-level factors with matching levels but in a different order.
}
\description{
Define a conformance rule to match a factor with specific levels.
}
\examples{
f = type.enum(one,two,three)
f(c("three","two","one"))
f(factor(rep(1:3,5), labels = c("one","two","three")))
}
\concept{rules}
