% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_traceline.R
\name{plot.traceline}
\alias{plot.traceline}
\title{Plot Item and Test Characteristic Curves}
\usage{
\method{plot}{traceline}(
  x,
  item.loc = NULL,
  score.curve = FALSE,
  overlap = FALSE,
  layout.col = 2,
  xlab.text,
  ylab.text,
  main.text,
  lab.size = 15,
  main.size = 15,
  axis.size = 15,
  line.color,
  line.size = 1,
  strip.size = 12,
  ...
)
}
\arguments{
\item{x}{x An object of class \code{traceline} obtained from \code{\link[=traceline]{traceline()}}.}

\item{item.loc}{A numeric vector specifying the position(s) of the item(s) to
plot. If \code{NULL} (default), the test characteristic curve (TCC) for the
entire test form is plotted.}

\item{score.curve}{Logical. If \code{TRUE}, plots the item score curve, defined
as the weighted sum of category probabilities across score categories, in
a panel.

If \code{FALSE}, plots item characteristic curves (ICCs) for all score categories,
either in separate panels or in a single panel depending on the \code{overlap}
setting.

For dichotomous items, the item score curve is equivalent to the ICC for
score category 1. Ignored when \code{item.loc = NULL}. Default is \code{FALSE}.}

\item{overlap}{Logical. Determines how multiple curves are displayed when
plotting ICCs or item score curves.

If \code{TRUE}, curves are overlaid in a single panel using different colors.
If \code{FALSE}, each curve is drawn in a separate panel—either one panel per
item or per score category, depending on the setting of \code{score.curve}.}

\item{layout.col}{An integer value indicating the number of columns in the
plot when displaying multiple panels. Used only when \code{overlap = FALSE}.
Default is 2.}

\item{xlab.text, ylab.text}{Character strings specifying the labels for
the x and y axes, respectively.}

\item{main.text}{Character string specifying the overall title of the plot.}

\item{lab.size}{Numeric value specifying the font size of axis titles.
Default is 15.}

\item{main.size}{Numeric value specifying the font size of the plot title.
Default is 15.}

\item{axis.size}{Numeric value specifying the font size of axis tick labels.
Default is 15.}

\item{line.color}{A character string specifying the color of the plot lines.
See \url{http://www.cookbook-r.com/Graphs/Colors_(ggplot2)/} for available
color names.}

\item{line.size}{Numeric value specifying the thickness of plot lines.
Default is 1.}

\item{strip.size}{Numeric. Font size of facet labels when ICCs are plotted.}

\item{...}{Additional arguments passed to \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}} from
the \pkg{ggplot2} package.}
}
\value{
This method displays item characteristic curves (ICCs), item score
curves, or the test characteristic curve (TCC), depending on the specified
arguments.
}
\description{
This method visualizes item characteristic curves (ICCs), item score curves,
or the test characteristic curve (TCC) using the \pkg{ggplot2} package.
ICCs or item score curves can be plotted for one or more selected items,
while the TCC is plotted for the entire test form.
}
\details{
All plots are generated using the \pkg{ggplot2} package.
If \code{item.loc = NULL}, the test characteristic curve (TCC) for the entire test
form is plotted. If \code{item.loc} is specified, it should be a vector of
positive integers indicating the position(s) of the items to be plotted.
For example, if the test form includes ten items and you wish to plot the
score curves of the 1st, 2nd, and 3rd items, set \code{item.loc = 1:3}.
}
\examples{
## Example using a "-prm.txt" file exported from flexMIRT

# Import the "-prm.txt" output file from flexMIRT
flex_prm <- system.file("extdata", "flexmirt_sample-prm.txt", package = "irtQ")

# Read the item parameters and convert them to item metadata
test_flex <- bring.flexmirt(file = flex_prm, "par")$Group1$full_df

# Define a sequence of theta values
theta <- seq(-3, 3, 0.1)

# Compute item category probabilities and item/test characteristic functions
x <- traceline(x = test_flex, theta, D = 1)

# Plot the test characteristic curve (TCC) for the full test form
plot(x, item.loc = NULL)

# Plot ICCs for the first item (dichotomous),
# with a separate panel for each score category
plot(x, item.loc = 1, score.curve = FALSE, layout.col = 2)

# Plot ICCs for the first item in a single panel
# (all score categories overlaid)
plot(x, item.loc = 1, score.curve = FALSE, overlap = TRUE)

# Plot ICCs for multiple items (both dichotomous and polytomous),
# with each item's ICCs shown in a single panel
plot(x, item.loc = c(1:3, 53:55), score.curve = FALSE, overlap = TRUE)

# Plot the item score curve for the first item (dichotomous)
plot(x, item.loc = 1, score.curve = TRUE)

# Plot item score curves for the first six dichotomous items
# using multiple panels
plot(x, item.loc = 1:6, score.curve = TRUE, overlap = FALSE)

# Plot item score curves for the first six dichotomous items
# overlaid in a single panel
plot(x, item.loc = 1:6, score.curve = TRUE, overlap = TRUE)

# Plot ICCs for the last item (polytomous),
# with each score category in a separate panel
plot(x, item.loc = 55, score.curve = FALSE, layout.col = 2)

# Plot the item score curve for the last item (polytomous)
plot(x, item.loc = 55, score.curve = TRUE)

# Plot item score curves for the last three polytomous items
# using multiple panels
plot(x, item.loc = 53:55, score.curve = TRUE, overlap = FALSE)

# Plot item score curves for the last three polytomous items
# overlaid in a single panel
plot(x, item.loc = 53:55, score.curve = TRUE, overlap = TRUE)

}
\seealso{
\code{\link[=traceline]{traceline()}}
}
\author{
Hwanggyu Lim \email{hglim83@gmail.com}
}
