% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visibility.R
\name{calc_visibility}
\alias{calc_visibility}
\title{Calculate indices of visible voxels when rendered from the specified view.}
\usage{
calc_visibility(
  coords,
  xyplane = "flat",
  handedness = "right",
  value = "index",
  verbosity = 0,
  ...
)
}
\arguments{
\item{coords}{data.frame of x,y,z coordinates for the cubes (integer coordinates)}

\item{xyplane}{How is the xyplane oriented with respect to the unit isometric
cube?.  "left", "right", "flat" (or "top").
Default: "flat".}

\item{handedness}{How is the z-axis positioned with respect to the xy-plane?
I.e. is this a right-handed or left-handed coordinate system?
Default: "right"}

\item{value}{type of value to return. Default: 'index'.  Valid values are
'index' and 'full'.  If 'index', then returns an integer vector of 
which rows to render in back-to-front ordering.  'full' returns
more information in a data.frame}

\item{verbosity}{Verbosity level. Default: 0}

\item{...}{other values passed to \code{gpar()} to set the graphical
parameters e.g. \code{lwd} and \code{col} for the linewidth and colour
of the outline stroke for each cube face.}
}
\value{
if value argument is 'index' then integer vector of visible 
        vertices in back-to-front draw ordering.
        For \code{value = 'full'} return a data.frame with more complete
        information.
}
\description{
Returned value is depth-sorted in back-to-front rendering order
}
\examples{
obj_sphere <- gen_sphere()
nrow(obj_sphere)
calc_visibility(obj_sphere) |>
   length()
   
calc_visibility(obj_sphere, value = 'full') |>
   head()
}
