% Generated by roxygen2 (4.0.1): do not edit by hand
\name{irepeat}
\alias{irepeat}
\title{Iterator that returns an object indefinitely}
\usage{
irepeat(object, times = NULL)
}
\arguments{
\item{object}{object to return indefinitely.}

\item{times}{the number of times \code{object} is returned. If \code{NULL}
(default), \code{object} is returned indefinitely.}
}
\value{
iterator that returns \code{object}
}
\description{
Constructs an iterator that returns an object over and over again.
}
\details{
Runs indefinitely unless the \code{times} argument is specified. Used as
argument to \code{\link[itertools2]{imap}} for invariant function
parameters. Also used with \code{\link[itertools2]{izip}} to create constant
fields in a tuple record.
}
\examples{
it <- irepeat(42)
iterators::nextElem(it)
iterators::nextElem(it)
iterators::nextElem(it)
# Further calls to iterators::nextElem(it) will repeat 42

it2 <- irepeat(42, times=4)
iterators::nextElem(it2)
iterators::nextElem(it2)
iterators::nextElem(it2)
iterators::nextElem(it2)

# The object can be a data.frame, matrix, etc
it3 <- irepeat(iris, times=4)
iterators::nextElem(it3)
iterators::nextElem(it3)
iterators::nextElem(it3)
iterators::nextElem(it3)
}

