% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp.R
\name{lpSetupBound}
\alias{lpSetupBound}
\title{Configure LP environment for obtaining the bounds}
\usage{
lpSetupBound(
  env,
  g0,
  g1,
  sset,
  criterion.tol,
  criterion.min,
  solver,
  setup = TRUE
)
}
\arguments{
\item{env}{the environment containing the LP model.}

\item{g0}{set of expectations for each terms of the MTR for the
control group.}

\item{g1}{set of expectations for each terms of the MTR for the
control group.}

\item{sset}{a list containing the point estimates and gamma
components associated with each element in the S-set. This
object is only used to determine the names of terms. If it is
no submitted, then no names are provided to the solution
vector.}

\item{criterion.tol}{additional multiplicative factor for how much
more the solution is permitted to violate observational
equivalence of the IV-like estimands, i.e. \code{1 +
criterion.tol} will multiply \code{criterion.min} directly.}

\item{criterion.min}{minimum criterion, i.e. minimum deviation from
observational equivalence while satisfying shape constraints.}

\item{solver}{string, name of the package used to solve the LP
problem.}

\item{setup}{boolean. If \code{TRUE}, the function will modify the
LP environment so that the LP solver can obtain the bounds. If
\code{FALSE}, then it will undo the changes made by the
function if \code{setup = TRUE}.}
}
\value{
Nothing, as this modifies an environment variable to save
    memory.
}
\description{
This function sets up the LP model so that the bounds can be
obtained. The LP model must be passed as an environment variable,
under the entry \code{$model}. See \code{\link{lpSetup}}.
}
