% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{momentMatrix}
\alias{momentMatrix}
\title{Construct pre-meaned moment matrix}
\usage{
momentMatrix(sset, gn0, gn1, subsetList = NULL, n = NULL)
}
\arguments{
\item{sset}{a list of lists constructed from the function
\link{genSSet}. Each inner list should include a coefficient
corresponding to a term in an IV specification, a matrix of the
estimates of the gamma moments conditional on (X, Z) for d = 0,
and a matrix of the estimates of the gamma moments conditional
on (X, Z) for d = 1. The column means of the last two matrices
is what is used to generate the gamma moments.}

\item{gn0}{integer, number of terms in the MTR for control group.}

\item{gn1}{integer, number of terms in the MTR for treated group.}

\item{subsetList}{list of subset indexes, one for each IV-like
specification.}

\item{n}{number of observations in the data. This option is only
used when subsets are involved.}
}
\value{
matrix whose column means can be used to carry out the GMM
    estimation.
}
\description{
This function constructs the matrix to be fed into the GMM
estimator to construct the moment conditions.
}
